// Parser fr Online-Rechner Ausgabenlogik
// 11.08.2021 - 14.08.2021
    
// Suche nach einem Zeichen (auerhalb von Klammern, mglichst weit rechts):
// ch ... Gesuchtes Zeichen
// s .... Durchsuchte Zeichenkette
// Rckgabewert: Position des Zeichens oder (bei erfolgloser Suche) -1
    
function rightPosChar (ch, s) {
  var level = 0;                                           // Klammerebene bezglich runder Klammern
  var level2 = 0;                                          // Klammerebene bezglich geschweifter Klammern
  var iMax = -1;                                           // Variable fr Position des gesuchten Zeichens
  for (var i=0; i<s.length; i++) {                         // Fr alle Zeichenpositionen ...
    var chI = s.charAt(i);                                 // Aktuelles Zeichen
    if (chI == "(") level++;                               // Falls runde Klammer auf, Klammerebene erhhen
    if (chI == ")") level--;                               // Falls runde Klammer zu, Klammerebene erniedrigen
    if (chI == "\{") level2++;                             // Falls geschweifte Klammer auf, Klammerebene erhhen
    if (chI == "\}") level2--;                             // Falls geschweifte Klammer zu, Klammerebene erniedrigen
    if (level == 0 && level2 == 0 && chI == ch)            // Falls richtiges Zeichen auerhalb Klammer ...       
      iMax = i;                                            // iMax aktualisieren
    } 
  return iMax;                                             // Rckgabewert
  }
  
// Bestandteile eines binren Terms (Kennbuchstabe E, I, O oder U):
// s .... Zeichenkette
// ch ... Kennbuchstabe
// Rckgabewert: Array der Bestandteile (Kennbuchstabe, 1. Teilstring, 2. Teilstring) oder undefined

function partsBinTerm (s, ch) {
  var i = rightPosChar(ch,s);                              // Position des Rechenzeichens (mglichst weit rechts)
  if (i < 0) return undefined;                             // Falls Rechenzeichen nicht vorhanden, Rckgabewert undefiniert
  var s1 = s.substring(0,i);                               // 1. Teil
  var s2 = s.substring(i+1);                               // 2. Teil
  return [ch, s1, s2];                                     // Rckgabewert im Normalfall
  }
  
// Bestandteile einer Negation (Kennbuchstabe N):
// s ... Zeichenkette
// Rckgabewert: Array der Bestandteile (Buchstabe N, Teilstring) oder undefined

function partsNeg (s) {
  if (!s.startsWith("N")) return undefined;                // Falls kein N am Anfang, Rckgabewert undefiniert
  return ["N", s.substring(1)];                            // Rckgabewert im Normalfall
  }
    
// Bestandteile einer runden Klammer:
// s ... Zeichenkette
// Rckgabewert: Array der Bestandteile (Zustand, Inhalt) oder undefined
// Zustand "1", falls Klammer nicht geschlossen, Zustand "2", falls Klammer geschlossen

function partsBrack (s) {
  if (s.charAt(0) != "(") return undefined;                // Falls nicht Klammer auf am Anfang, Rckgabewert undefined
  var level = 0;                                           // Klammerebene
  for (var i=0; i<s.length; i++) {                         // Fr alle Zeichenpositionen ...
    var ch = s.charAt(i);                                  // Aktuelles Zeichen
    if (ch == "(") level++;                                // Falls Klammer auf, Klammerebene erhhen
    if (ch == ")") level--;                                // Falls Klammer zu, Klammerebene erniedrigen
    if (level == 0 && ch == ")" && i < s.length-1)         // Falls vorzeitig Klammer zu ... 
      return undefined;                                    // Rckgabewert undefined
    }
  if (level > 0) return ["1", s.substring(1)];            // Rckgabewert fr unvollstndige runde Klammer
  else return ["2", s.substring(1,s.length-1)];           // Rckgabewert fr vollstndige runde Klammer 
  }
  
// Hilfsroutine: Vergleich einer Zeichenkette mit einem Muster
// s ... Zeichenkette
// p ... Zeichenkette fr Muster (regulrer Ausdruck); Vorsicht bei bestimmten Zeichen (Punkt)!
// Rckgabewert: Bei bereinstimmung true, sonst false

function like (s, p) {
  var a = s.match(new RegExp(p));                          // Array von passenden Teilstrings
  return (a != null && a.length == 1 && a[0] == s);        // Rckgabewert
  }
  
// berprfung, ob eine Zeichenkette einer Variablen entspricht:
// s ... Zeichenkette
// Rckgabewert: Bei Variable true, sonst false

function isVar (s) {
  return like(s,"[a-z]");                                  // Rckgabewert
  }

// Hilfsroutine: Klammerebene am Ende einer Zeichenkette
// s ..... Zeichenkette
// ch1 ... Zeichen fr ffnende Klammer
// ch2 ... Zeichen fr schlieende Klammer

function level (s, ch1, ch2) {
  var lev = 0;                                             // Klammerebene, Startwert
  for (var i=0; i<s.length; i++) {                         // Fr alle Zeichenpositionen ...
    if (s.charAt(i) == ch1) lev++;                         // Falls ffnende Klammer, Klammerebene erhhen
    if (s.charAt(i) == ch2) lev--;                         // Falls schlieende Klammer, Klammerebene erniedrigen
    }
  return lev;                                              // Rckgabewert
  }
  
// Konstruktion eines Terms (rekursiv):
// s ....... Zeichenkette
// (x,y) ... Position (Pixel)

function constrTerm (s, x, y) {
  if (s == "") return new Empty(x,y);                      // Rckgabewert (leerer Term)
  var a = partsBinTerm(s,"E");                             // Bestandteile einer quivalenz oder undefined
  if (a != undefined) return new Equivalence(a,x,y);       // Rckgabewert (quivalenz)
  a = partsBinTerm(s,"I");                                 // Bestandteile einer Implikation oder undefined
  if (a != undefined) return new Implication(a,x,y);       // Rckgabewert (Implikation)
  a = partsBinTerm(s,"O");                                 // Bestandteile einer Disjunktion oder undefined
  if (a != undefined) return new Disjunction(a,x,y);       // Rckgabewert (Disjunktion)
  a = partsBinTerm(s,"U");                                 // Bestandteile einer Konjunktion oder undefined
  if (a != undefined) return new Conjunction(a,x,y);       // Rckgabewert (Konjunktion)
  a = partsNeg(s);                                         // Bestandteile einer Negation oder undefined
  if (a != undefined) return new Negation(a,x,y);          // Rckgabewert (Negation)
  a = partsBrack(s);                                       // Bestandteile einer runden Klammer
  if (a != undefined) return new Brack(a,x,y);             // Rckgabewert (unvollstndige oder vollstndige runde Klammer)
  if (isVar(s)) return new Var(s,x,y);                     // Rckgabewert (Variable)
  if (s == "F") return new False(s,x,y);                   // Rckgabewert (Konstante False)
  if (s == "W") return new True(s,x,y);                    // Rckgabewert (Konstante True)
  if (level(s,"(",")") < 0) throw closingBracket;          // Falls berzhlige schlieende Klammer, Ausnahme
  throw unknownError;                                      // Falls unverstndlich, Ausnahme
  }
  
