// Primzahlentabelle
// Java-Applet (17.10.2003) umgewandelt
// 29.07.2015 - 18.10.2015

// Farben:

var colorBackground = "#ffff00";                           // Hintergrundfarbe fr Tabelle
var colorPrime = "#ffc040";                                // Hintergrundfarbe fr Primzahlen
var colorNumber = "#0000ff";                               // Farbe fr Rahmen (aktuelle Zahl)

// Weitere Konstanten:

var widthCell = 100;                                       // Breite einer Tabellenzelle (Pixel)
var heightCell = 20;                                       // Hhe einer Tabellenzelle (Pixel)
var FONT = "normal normal bold 12px sans-serif";           // Zeichensatz

// Attribute:

var canvas, ctx;                                           // Zeichenflche, Grafikkontext
var width, height;                                         // Abmessungen der Zeichenflche (Pixel)
var ip;                                                    // Eingabefeld (Zahl)
var op1, op2;                                              // Ausgabefelder (Primzahleigenschaft oder Primfaktorzerlegung)
var dx, dy;                                                // Position des Zelleninhalts (Pixel)
var offsetX;                                               // Waagrechte Verschiebung der Tabelle (Pixel)
var offsetY;                                               // Senkrechte Verschiebung der Tabelle (Pixel)
var drag;                                                  // Flag fr Zugmodus
var number;                                                // Aktuelle Zahl
var ipf;                                                   // Flag fr Verwendung des Eingabefelds (normalerweise true)
var dn;                                                    // Hilfsgre
var prime;                                                 // Array mit Flags fr Primzahleigenschaft
var xMouse, yMouse;                                        // Position des Mauszeigers (Pixel)

// Start:

function start () {
  canvas = document.getElementById("cv");                  // Zeichenflche
  width = canvas.width; height = canvas.height;            // Abmessungen der Zeichenflche (Pixel)
  ctx = canvas.getContext("2d");                           // Grafikkontext
  ip = document.getElementById("ip");                      // Eingabefeld (Zahl)
  ip.value = "2";                                          // Default-Wert fr Eingabefeld
  ip.focus();                                              // Fokus fr Eingabefeld
  op1 = document.getElementById("op1");                    // Oberes Ausgabefeld
  op2 = document.getElementById("op2");                    // Unteres Ausgabefeld
  ipf = true;                                              // Flag fr Verwendung des Eingabefelds
  dx = widthCell/2;                                        // Waagrechte Position des Zelleninhalts (Pixel)  
  dy = heightCell/2+4;                                     // Senkrechte Position des Zelleninhalts (Pixel)
  dn = 10*Math.ceil(height/heightCell);                    // Hilfsgre
  prime = new Array(2*dn+1);                               // Array fr Primzahleigenschaft
  reaction();                                              // Reaktion auf Eingabe
  drag = false;                                            // Zugmodus zunchst ausgeschaltet
  ip.onkeydown = reactionEnter;                            // Reaktion auf Eingabefeld
  
  canvas.onmousedown = function (e) {                      // Reaktion auf Drcken der Maustaste
    reactionDown(e.clientX,e.clientY);           
    }
    
  canvas.ontouchstart = function (e) {                     // Reaktion auf Berhrung
    var obj = e.changedTouches[0];
    reactionDown(obj.clientX,obj.clientY);     
    if (drag) e.preventDefault();                          // Standardverhalten verhindern
    }
      
  canvas.onmouseup = function (e) {                        // Reaktion auf Loslassen der Maustaste
    drag = false;                        
    }
    
  canvas.ontouchend = function (e) {                       // Reaktion auf Ende der Berhrung
    drag = false;                       
    }
    
  canvas.onmousemove = function (e) {                      // Reaktion auf Bewegen der Maus
    reactionMove(e.clientX,e.clientY);                     // Position ermitteln und neu zeichnen
    }
    
  canvas.ontouchmove = function (e) {                      // Reaktion auf Bewegung mit Finger
    var obj = e.changedTouches[0];
    reactionMove(obj.clientX,obj.clientY);                 // Position ermitteln und neu zeichnen
    e.preventDefault();                                    // Standardverhalten verhindern                          
    }
  }
  
// Reaktion auf Tastendruck (nur auf Enter-Taste):
  
function reactionEnter (e) {
  if (e.key && String(e.key) == "Enter"                    // Falls Entertaste (Firefox/Internet Explorer) ...
  || e.keyCode == 13)                                      // Falls Entertaste (Chrome) ...
    reaction();                                            // ... Daten bernehmen, rechnen, Tabelle neu zeichnen                          
  }
  
// Reaktion auf Eingabe einer Zahl:
// Seiteneffekt number, prime, offsetX, offsetY
// Wirkung auf Ein- und Ausgabefelder
  
function reaction () {
  var n = Number(ip.value);                                // Zahl im Eingabefeld
  if (!n || n != Math.floor(n)) {                          // Falls sinnlose Eingabe ...
    alert(textError);                                      // Fehlermeldung
    ip.value = number;                                     // Bisherige Zahl im Eingabefeld
    return;                                                // Abbruch
    }                 
  number = n;                                              // Gegebene Zahl aktualisieren
  if (number < 1) {                                        // Falls Zahl zu klein ...
    number = 1;                                            // Zahl korrigieren
    ip.value = 1;                                          // Eingabe korrigieren
    }
  if (number > 1e12) {                                     // Falls Zahl zu gro ...
    number = 1e12;                                         // Zahl korrigieren
    ip.value = 1e12;                                       // Eingabe korrigieren
    }
  for (var i=0; i<=2*dn; i++)                              // Fr alle Indizes ...
    prime[i] = isPrime(number-dn+i);                       // Flags fr Primzahleigenschaft setzen
  var a = arrayFactors(number);                            // Array der Primfaktoren (aufsteigend sortiert)
  op1.innerHTML = output1(a);                              // Obere Ausgabezeile (Schreibweise ohne Potenzen)
  op2.innerHTML = output2(a);                              // Untere Ausgabezeile (Schreibweise mit Potenzen)
  if (ipf) calcOffset();                                   // Falls ntig, neue Werte von offsetX und offsetY berechnen
  paint();                                                 // Tabellenabschnitt neu zeichnen
  }
  
// Reaktion auf Mausklick oder Berhrung mit dem Finger:
// Seiteneffekt drag, xMouse, yMouse, ipf, number, prime, offsetX, offsetY
// Wirkung auf Ein- und Ausgabefelder
  
function reactionDown (x, y) {
  drag = true;                                             // Zugmodus eingeschaltet
  var re = canvas.getBoundingClientRect();                 // Lage der Zeichenflche bezglich Viewport
  x -= re.left; y -= re.top;                               // Koordinaten bezglich Zeichenflche
  xMouse = x; yMouse = y;                                  // Mausposition abspeichern
  x += offsetX; y += offsetY;                              // Koordinaten gegenber Ursprung des Tabellenabschnitts
  var n = 1+Math.floor(x/widthCell)+10*Math.floor(y/heightCell); // Neue Zahl
  ip.value = n;                                            // Eingabefeld aktualisieren
  ipf = false;                                             // Flag fr Verwendung des Eingabefelds
  reaction();                                              // Reaktion auf Eingabe
  ipf = true;                                              // Flag fr Verwendung des Eingabefelds zurcksetzen  
  }
  
// Reaktion auf Bewegung der Maus oder des Fingers:
// Seiteneffekt offsetX, offsetY, xMouse, yMouse
  
function reactionMove (x, y) {
  if (!drag) return;                                       // Falls kein Zugmodus, abbrechen  
  var re = canvas.getBoundingClientRect();                 // Lage der Zeichenflche bezglich Viewport
  x -= re.left; y -= re.top;                               // Koordinaten bezglich Zeichenflche  
  offsetX += (xMouse-x);                                   // Neuer Wert der waagrechten Verschiebung
  offsetY += (yMouse-y);                                   // Neuer Wert der senkrechten Verschiebung
  restrictOffset();                                        // Zu groe Verschiebung verhindern  
  xMouse = x; yMouse = y;                                  // Neue Mausposition speichern
  paint();                                                 // Tabellenabschnitt neu zeichnen
  }
  
//-------------------------------------------------------------------------------------------------

// Kleinster Primfaktor:
// z ... Gegebene Zahl
// Rckgabewert: Kleinster Primfaktor der gegebenen Zahl, falls definiert; andernfalls undefined 
  
function firstPrime (z) {
  if (z <= 1) return undefined;                            // Falls Zahl zu klein, Rckgabewert undefined
  if (Math.floor(z) != z) return undefined;                // Falls Zahl nicht natrlich, Rckgabewert undefined
  for (var t=2; t*t<=z; t++)                               // Fr alle denkbaren Teiler ab 2 ...
    if (z%t == 0) return t;                                // Teiler als Rckgabewert
  return z;                                                // Gegebene Zahl (Primzahl) als Rckgabewert
  } 
  	
// Primzahleigenschaft:
// z ... Gegebene Zahl
// Rckgabewert: true fr Primzahl, sonst false
  
function isPrime (z) {
  return (firstPrime(z) == z);                             // Rckgabewert
  }
  
// Array fr Faktorenzerlegung:
// n ... Gegebene natrliche Zahl

function arrayFactors (n) {
  var a = new Array();                                     // Leeres Array
  var f = firstPrime(n);                                   // Kleinster Primfaktor
  while (f) {                                              // Solange Primfaktor vorhanden ...
    a.push(f);                                             // Faktor zum Array hinzufgen
    n /= f;                                                // Durch diesen Faktor dividieren
    f = firstPrime(n);                                     // Kleinster Primfaktor
    }
  return a;                                                // Rckgabewert
  }
  
// Zeichenkette fr Faktorisierung (Schreibweise ohne Potenzen):
// a ... Array der Primfaktoren (aufsteigend sortiert)

function output1 (a) {
  var n = a.length;                                        // Gre des Arrays (Anzahl der Faktoren)
  if (n == 0) return "";                                   // Sonderfall (leeres Array fr 1)
  if (n == 1) return textPrime;                            // Sonderfall (Array mit einem Element fr Primzahl)
  var s = "= ";                                            // Anfang der Zeichenkette fr Normalfall
  for (var i=0; i<n; i++) {                                // Fr alle Elemente des Arrays ...
    s += a[i];                                             // Faktor zur Zeichenkette hinzufgen
    if (i < n-1)  s += " "+symbolMult+" ";                 // Falls ntig, Multiplikationszeichen hinzufgen
    }
  return s;                                                // Rckgabewert
  }
  
// Zeichenkette fr Faktorisierung (Schreibweise mit Potenzen):
// a ... Array der Primfaktoren (aufsteigend sortiert)
// Falls sich die Schreibweise mit Potenzen nicht auswirkt, wird eine leere Zeichenkette zurckgegeben.

function output2 (a) {
  var n = a.length;                                        // Gre des Arrays (Anzahl der Faktoren)
  if (n <= 1) return "";                                   // Sonderfall (leere Zeichenkette fr 1 und Primzahlen)
  var s = "= ";                                            // Anfang der Zeichenkette fr Normalfall
  var o = false;                                           // Flag fr Unterschied zur Schreibweise ohne Potenzen
  var f = 0;                                               // Variable fr aktuellen Primfaktor
  for (var i=0; i<n; i++) {                                // Fr alle Indizes ...
    var ff = a[i];                                         // Faktor aus dem gegebenen Array
    if (ff != f) {                                         // Falls Faktor bisher nicht vorgekommen ...
      if (i > 0) s += " "+symbolMult+" ";                  // Multiplikationszeichen hinzufgen (auer beim ersten Faktor)
      f = ff;                                              // Aktuellen Faktor bernehmen
      s += f;                                              // Aktuellen Faktor zur Zeichenkette hinzufgen                                              
      var e = 0;                                           // Exponent zum aktuellen Faktor
      do {i++; ff = a[i]; e++;} while (ff == f);           // Index und Exponent hochzhlen, bis ein anderer Faktor auftaucht
      i--;                                                 // Index fr den letzten der gleichen Faktoren 
      if (e > 1) {                                         // Falls Exponent grer als 1 ...
        s += "<sup>"+e+"</sup>";                           // HTML fr den Exponenten zur Zeichenkette hinzufgen 
        o = true;                                          // Flag fr Unterschied zur Schreibweise ohne Potenzen setzen
        }
      }
    }
  return (o ? s : "");                                     // Rckgabewert
  }
  
// Berechnung der Tabellen-Verschiebung nach Verwendung des Eingabefelds:
// Seiteneffekt offsetX, offsetY
// Die Zelle der aktuellen Zahl soll in der Mitte liegen, wenn dies ohne extreme Verschiebung mglich ist.
  
function calcOffset () {
  offsetX = ((number-1)%10)*widthCell-(width-widthCell)/2; // Waagrechte Verschiebung (Pixel)
  offsetY = Math.floor((number-1)/10)*heightCell;          // Senkrechte Verschiebung (Pixel)
  offsetY -= (height-heightCell)/2;
  restrictOffset();                                        // Zu groe Verschiebung verhindern
  }
  
// Begrenzung der Tabellen-Verschiebung:
// Seiteneffekt offsetX, offsetY

function restrictOffset () {
  if (offsetX < -widthCell) offsetX = -widthCell;          // Verschiebung nach rechts begrenzen
  var max = 11*widthCell-width;                            // Maximum fr offsetX
  if (offsetX > max) offsetX = max;                        // Verschiebung nach links begrenzen
  if (offsetY < 0) offsetY = 0;                            // Verschiebung nach unten begrenzen
  max = 1e11*heightCell-height;                            // Maximum fr offsetY
  if (offsetY > max) offsetY = max;                        // Verschiebung nach oben begrenzen
  }
  
// Berechnung der waagrechten Koordinate der linken oberen Ecke einer Zelle:
// n ... Gegebene Zahl

function xCell (n) {
  var c = (n-1)%10;                                        // Index der Spalte (Zhlung ab 0)
  return c*widthCell-offsetX;                              // Rckgabewert
  }
  
// Berechnung der senkrechten Koordinate der linken oberen Ecke einer Zelle:
// n ... Gegebene Zahl

function yCell (n) {
  var r = Math.floor((n-1)/10);                            // Index der Zeile (Zhlung ab 0)
  return r*heightCell-offsetY;                             // Rckgabewert
  }
    
//-------------------------------------------------------------------------------------------------

// Ausgabe des sichtbaren Tabellenabschnitts:
  
function paint () {
  ctx.fillStyle = colorBackground;                         // Hintergrundfarbe
  ctx.fillRect(0,0,width,height);                          // Hintergrund ausfllen
  ctx.font = FONT;                                         // Zeichensatz
  ctx.strokeStyle = "#000000";                             // Farbe fr Rand einer Zelle (schwarz)
  ctx.lineWidth = 1;                                       // Liniendicke
  ctx.textAlign = "center";                                // Zentrierung innerhalb einer Zelle
  var min = number-dn;                                     // Schtzwert fr die kleinste Zahl des sichtbaren Tabellenabschnitts
  var max = number+dn;                                     // Schtzwert fr die grte Zahl des sichtbaren Tabellenabschnitts
  if (max > 1e12) max = 1e12;                              // Grte Zahl hchstens 1 000 000 000 000
  for (var n=min; n<=max; n++) {                           // Fr alle Zahlen des sichtbaren Tabellenabschnitts ...                   
    var x = xCell(n), y = yCell(n);                        // Koordinaten der linken oberen Ecke der Zelle (Pixel)
    if (prime[n-min]) {                                    // Falls Primzahl ...
      ctx.fillStyle = colorPrime;                          // Hintergrundfarbe fr Primzahlen
      ctx.fillRect(x,y,widthCell,heightCell);              // Hintergrund der Zelle ausfllen
      }
    ctx.strokeRect(x,y,widthCell,heightCell);              // Rand der Zelle
    ctx.fillStyle = "#000000";                             // Schriftfarbe (schwarz)
    ctx.fillText(""+n,x+dx,y+dy);                          // Zahl in die Mitte der Zelle schreiben  
    }
  ctx.strokeStyle = colorNumber;                           // Farbe fr Rahmen (aktuelle Zahl)
  ctx.lineWidth = 3;                                       // Liniendicke
  x = xCell(number); y = yCell(number);                    // Koordinaten der linken oberen Ecke der hervorgehobenen Zelle
  ctx.strokeRect(x,y,widthCell,heightCell);                // Rahmen zeichnen 
  }
  
document.addEventListener("DOMContentLoaded",start,false); // Nach dem Laden der Seite Start-Methode aufrufen


