// Satz des Pythagoras
// Java-Applet (19.02.2001) umgewandelt
// 03.03.2017 - 05.03.2017

// ****************************************************************************
// * Autor: Walter Fendt (www.walter-fendt.de)                                *
// * Dieses Programm darf - auch in vernderter Form - fr nicht-kommerzielle *
// * Zwecke verwendet und weitergegeben werden, solange dieser Hinweis nicht  *
// * entfernt wird.                                                           *
// **************************************************************************** 

// Sprachabhngige Texte sind einer eigenen Datei (zum Beispiel pythagoras2_de.js) abgespeichert.

// Farben:

var colorBackground = "#ffff00";                           // Hintergrundfarbe
var color0 = "#00ff00";                                    // Farbe fr Dreiecke
var color1 = "#0000ff";                                    // Farbe fr Kathete a bzw. Kathetenquadrat a
var color2 = "#ff0000";                                    // Farbe fr Kathete b bzw. Kathetenquadrat b
var color3 = "#c00080";                                    // Farbe fr Hypotenuse c bzw. Hypotenusenquadrat c

// Konstanten:

var PIX = 0.75;                                            // Umrechnungsfaktor (Pixel pro Lngeneinheit)

// Attribute:

var canvas, ctx;                                           // Zeichenflche, Grafikkontext
var width, height;                                         // Abmessungen der Zeichenflche (Pixel)
var sl1, sl2;                                              // Schieberegler
var lb1a, lb2a, lb3a;                                      // Ausgabefelder (Seitenlngen)
var lb1b, lb2b, lb3b;                                      // Ausgabefelder (Seitenquadrate)

var a, b;                                                  // Katheten
var c;                                                     // Hypotenuse
var p, q;                                                  // Hypotenusenabschnitte (rechts bzw. links)
var h;                                                     // Hhe (bezglich Hypotenuse)
var poly3;                                                 // Array fr Dreieck
var poly4;                                                 // Array fr nicht achsenparalleles Quadrat

// Element der Schaltflche (aus HTML-Datei):
// id ..... ID im HTML-Befehl
// text ... Text (optional)

function getElement (id, text) {
  var e = document.getElementById(id);                     // Element
  if (text) e.innerHTML = text;                            // Text festlegen, falls definiert
  return e;                                                // Rckgabewert
  } 

// Start:

function start () {
  canvas = getElement("cv");                               // Zeichenflche
  width = canvas.width; height = canvas.height;            // Abmessungen (Pixel)
  ctx = canvas.getContext("2d");                           // Grafikkontext
  sl1 = getElement("sl1");                                 // 1. Schieberegler (Kathete a)
  sl1.value = 60;                                          // Anfangsstellung
  sl2 = getElement("sl2");                                 // 2. Schieberegler (Kathete b)
  sl2.value = 80;                                          // Anfangsstellung
  lb1a = getElement("lb1a");                               // Ausgabefeld a
  lb1b = getElement("lb1b");                               // Ausgabefeld a
  lb2a = getElement("lb2a");                               // Ausgabefeld b
  lb2b = getElement("lb2b");                               // Ausgabefeld b
  lb3a = getElement("lb3a");                               // Ausgabefeld c
  lb3b = getElement("lb3b");                               // Ausgabefeld c  
  getElement("author",author);                             // Autor
  getElement("translator",translator);                     // bersetzer
  a = sl1.value; b = sl2.value;                            // Katheten
  calculation();                                           // Berechnungen (c, p, q, h)
  updateOutput();                                          // Ausgabefelder aktualisieren
  poly3 = new Array(3);                                    // Array fr Dreieck
  poly4 = new Array(4);                                    // Array fr nicht achsenparalleles Quadrat
  paint();                                                 // Zeichnen
  
  sl1.onchange = reactionSlider1;                          // Reaktion auf Schieberegler 1 (Internet Explorer)
  sl1.oninput = reactionSlider1;                           // Reaktion auf Schieberegler 1 (Firefox, Chrome)
  sl2.onchange = reactionSlider2;                          // Reaktion auf Schieberegler 2 (Internet Explorer)
  sl2.oninput = reactionSlider2;                           // Reaktion auf Schieberegler 2 (Firefox, Chrome)
    
  } // Ende der Methode start
   
// Reaktion auf oberen Schieberegler (Kathete a):
  
function reactionSlider1 () {
  a = sl1.value;                                           // Kathete a
  calculation();                                           // Berechnungen (c, p, q, h)
  updateOutput();                                          // Ausgabefelder aktualisieren
  paint();                                                 // Neu zeichnen
  }
  
// Reaktion auf unteren Schieberegler (Kathete b):
  
function reactionSlider2 () {
  b = sl2.value;                                           // Kathete b
  calculation();                                           // Berechnungen (c, p, q, h)
  updateOutput();                                          // Ausgabefelder aktualisieren
  paint();                                                 // Neu zeichnen
  }
  
// Ausgabefelder aktualisieren:
  
function updateOutput () {
  lb1a.innerHTML = "a = "+a;                               // Kathete a (ganzzahlig)
  lb1b.innerHTML = "a&sup2; = "+a*a;                       // Kathetenquadrat a (ganzzahlig)
  lb2a.innerHTML = "b = "+b;                               // Kathete b (ganzzahlig)
  lb2b.innerHTML = "b&sup2; = "+b*b;                       // Kathetenquadrat b (ganzzahlig)
  lb3a.innerHTML = "c = "+ToString(c,5);                   // Hypotenuse c (5 Nachkommastellen)
  lb3b.innerHTML = "c&sup2; = "+(a*a+b*b);                 // Hypotenusenquadrat c (ganzzahlig)
  }
  
//-------------------------------------------------------------------------------------------------

// Umwandlung einer Zahl in eine Zeichenkette (gerundet):
// n ... Gegebene Zahl
// d ... Zahl der Nachkommastellen

function ToString (n, d) {
  var s = n.toFixed(d);                                    // Runden, umwandeln in eine Zeichenkette
  return s.replace(".",decimalSeparator);                  // Rckgabewert (Komma oder Punkt)
  }
  
// Berechnungen:
// Seiteneffekt c, p, q, h 

function calculation () {
  c = Math.sqrt(a*a+b*b);                                  // Hypotenuse 
  p = (c>0 ? a*a/c : 0);                                   // Rechter Hypotenusenabschnitt
  q = (c>0 ? b*b/c : 0);                                   // Linker Hypotenusenabschnitt
  h = (c>0 ? a*b/c : 0);                                   // Hhe bezglich Hypotenuse
  }
  
// Polygonecke festlegen:
// p ...... Array fr Koordinaten der Polygonecken
// i ...... Index der Ecke
// x, y ... Koordinaten
  
function setPoint (p, i, x, y) {
  p[i]= {u: x, v: y};
  }

//-------------------------------------------------------------------------------------------------

// Neuer Pfad mit Standardwerten:

function newPath() {
  ctx.beginPath();                                         // Neuer Grafikpfad
  ctx.strokeStyle = "#000000";                             // Linienfarbe schwarz
  ctx.lineWidth = 1;                                       // Liniendicke
  }
  
// Achsenparalleles Quadrat zeichnen (ausgefllt):
// x, y ... Koordinaten der Ecke links oben
// a ...... Seitenlnge
// c ...... Fllfarbe

function drawSquare (x, y, a, c) {
  newPath();                                               // Neuer Grafikpfad (Standardwerte)
  ctx.rect(x,y,a,a);                                       // Quadrat vorbereiten
  ctx.fillStyle = c;                                       // Fllfarbe
  ctx.fill(); ctx.stroke();                                // Quadrat zeichnen
  }
  
// Polygon zeichnen (ausgefllt):
// p ... Array mit Koordinaten der Ecken
// c ... Fllfarbe

function drawPolygon (p, c) {
  newPath();                                               // Neuer Pfad
  ctx.fillStyle = c;                                       // Fllfarbe
  ctx.moveTo(p[0].u,p[0].v);                               // Zur ersten Ecke
  for (var i=1; i<p.length; i++)                           // Fr alle weiteren Ecken ... 
    ctx.lineTo(p[i].u,p[i].v);                             // Linie zum Pfad hinzufgen
  ctx.closePath();                                         // Zurck zum Ausgangspunkt
  ctx.fill(); ctx.stroke();                                // Polygon ausfllen und Rand zeichnen   
  }
  
// Skizze links:

function sketchLeft () {
  var cPix = PIX*c;                                        // Hypotenusenlnge (Pixel)
  var pPix = PIX*p, qPix = PIX*q;                          // Hypotenusenabschnitte rechts bzw. links (Pixel)
  var hPix = PIX*h;                                        // Hhe bezglich Hypotenuse (Pixel)
  var x0 = width/4;                                        // x-Koordinate Mittelpunkt
  var xL = x0-cPix/2;                                      // x-Koordinate Ecke A
  var xR = x0+cPix/2;                                      // x-Koordinate Ecke B
  var y0 = height/2;                                       // y-Koordinate Hypotenuse
  drawSquare(xL,y0,cPix,color3);                           // Unteres Quadrat (c)
  setPoint(poly3,0,xL,y0);                                 // Dreieck, Ecke links unten
  setPoint(poly3,1,xR,y0);                                 // Dreieck, Ecke rechts unten
  setPoint(poly3,2,xL+qPix,y0-hPix);                       // Dreieck, Ecke oben
  drawPolygon(poly3,color0);                               // Dreieck ausgefllt
  setPoint(poly4,0,xR,y0);                                 // Rechtes Quadrat (a), Ecke unten
  setPoint(poly4,1,xR+hPix,y0-pPix);                       // Rechtes Quadrat (a), Ecke rechts
  setPoint(poly4,2,xL+qPix+hPix,y0-hPix-pPix);             // Rechtes Quadrat (a), Ecke oben
  setPoint(poly4,3,xL+qPix,y0-hPix);                       // Rechtes Quadrat (a), Ecke links
  drawPolygon(poly4,color1);                               // Rechtes Quadrat (a) ausgefllt
  setPoint(poly4,0,xL,y0);                                 // Linkes Quadrat (b), Ecke unten
  setPoint(poly4,1,xL+qPix,y0-hPix);                       // Linkes Quadrat (b), Ecke rechts
  setPoint(poly4,2,xL+qPix-hPix,y0-hPix-qPix);             // Linkes Quadrat (b), Ecke oben
  setPoint(poly4,3,xL-hPix,y0-qPix);                       // Linkes Quadrat (b), Ecke links
  drawPolygon(poly4,color2);                               // Linkes Quadrat (b) ausgefllt
  }
  
// Skizze rechts oben:

function sketchRight1 () {
  var aPix = PIX*a, bPix = PIX*b;                          // Kathetenlngen (Pixel) 
  var ab = aPix+bPix, abH = ab/2;                          // Hilfsgren (a+b bzw. (a+b)/2 in Pixel)
  var x0 = 3*width/4;                                      // x-Koordinate Mittelpunkt
  var x1 = x0-abH;                                         // x-Koordinate linker Rand
  var x2 = x1+aPix;                                        // x-Koordinate senkrechte Trennlinie
  var x3 = x0+abH;                                         // x-Koordinate rechter Rand
  var y0 = height/4;                                       // y-Koordinate Mittelpunkt
  var y1 = y0-abH;                                         // y-Koordinate oberer Rand
  var y2 = y1+bPix;                                        // y-Koordinate waagrechte Trennlinie
  var y3 = y0+abH;                                         // y-Koordinate unterer Rand
  drawSquare(x1,y1,ab,color0);                             // Gesamtes Quadrat ((a+b), ausgefllt)
  drawSquare(x1,y2,aPix,color1);                           // Quadrat links unten (a, ausgefllt)
  drawSquare(x2,y1,bPix,color2);                           // Quadrat rechts oben (b, ausgefllt)  
  newPath();                                               // Neuer Grafikpfad (Standardwerte)
  ctx.moveTo(x1,y2); ctx.lineTo(x2,y1);                    // Diagonale links oben vorbereiten
  ctx.moveTo(x2,y2); ctx.lineTo(x3,y3);                    // Diagonale rechts unten vorbereiten
  ctx.stroke();                                            // Diagonalen zeichnen
  }
    
// Skizze rechts unten:

function sketchRight2 () {
  var aPix = PIX*a, bPix = PIX*b;                          // Kathetenlngen (Pixel) 
  var ab = aPix+bPix, abH = ab/2;                          // Hilfsgren (a+b bzw. (a+b)/2 in Pixel)
  var x0 = 3*width/4;                                      // x-Koordinate Mittelpunkt
  var x1 = x0-abH;                                         // x-Koordinate linker Rand
  var x2 = x0+abH;                                         // x-Koordinate rechter Rand
  var y0 = 3*height/4;                                     // y-Koordinate Mittelpunkt
  var y1 = y0-abH;                                         // y-Koordinate oberer Rand
  var y2 = y0+abH;                                         // y-Koordinate unterer Rand  
  drawSquare(x1,y1,ab,color0);                             // Gesamtes Quadrat ((a+b), ausgefllt)
  setPoint(poly4,0,x1+bPix,y2);                            // Ecke unten
  setPoint(poly4,1,x2,y1+aPix);                            // Ecke rechts
  setPoint(poly4,2,x2-bPix,y1);                            // Ecke oben
  setPoint(poly4,3,x1,y1+bPix);                            // Ecke links
  drawPolygon(poly4,color3);                               // Quadrat (c, ausgefllt)
  }

// Grafikausgabe:
  
function paint () {
  ctx.fillStyle = colorBackground;                         // Hintergrundfarbe
  ctx.fillRect(0,0,width,height);                          // Hintergrund ausfllen
  sketchLeft();                                            // Skizze links
  sketchRight1();                                          // Skizze rechts oben
  sketchRight2();                                          // Skizze rechts unten
  }
  
document.addEventListener("DOMContentLoaded",start,false); // Nach dem Laden der Seite Start-Methode aufrufen



