// Himmelspole
// Java-Applet (12.07.1998) umgewandelt
// 11.11.2015 - 11.11.2015

// ****************************************************************************
// * Autor: Walter Fendt (www.walter-fendt.de)                                *
// * Dieses Programm darf - auch in veränderter Form - für nicht-kommerzielle *
// * Zwecke verwendet und weitergegeben werden, solange dieser Hinweis nicht  *
// * entfernt wird.                                                           *
// **************************************************************************** 

// Sprachabhängige Texte sind in einer eigenen Datei (zum Beispiel celestialpoles_de.js) abgespeichert.

// Farben:

var colorBackground = "#ffff00";                           // Hintergrundfarbe
var colorNorth = "#ff0000";                                // Farbe für Nordrichtung
var colorSouth = "#008000";                                // Farbe für Südrichtung
var colorZenith = "#ff00ff";                               // Farbe für Zenitrichtung
var colorCelestialPole = "#0000ff";                        // Farbe für Himmelspole
var colorAngle = "#00ffff";                                // Farbe für Winkelmarkierungen

// Sonstige Konstanten:

var FONT = "normal normal bold 12px sans-serif";           // Zeichensatz
var DEG = Math.PI/180;                                     // 1 Grad (Bogenmaß)
var R0 = 60;                                               // Erdradius (links, Pixel)   
var xB1 = 500, yB1 = 250;                                  // Beobachtungsort (rechts, Pixel)
var R1 = 120;                                              // Radius der Himmelskugel (Pixel)

// Attribute:

var canvas, ctx;                                           // Zeichenfläche, Grafikkontext
var width, height;                                         // Abmessungen der Zeichenfläche (Pixel)
var drag;                                                  // Flag für Zugmodus

var xM0, yM0;                                              // Erdmittelpunkt (links)
var phi;                                                   // Geogr. Breite (Bogenmaß)
var xB0, yB0;                                              // Beobachtungsort (links)
var xP0, yP0;                                              // Himmelspol (links)
var xP1, yP1;                                              // Himmelspol (rechts)
var xN0, yN0;                                              // Norden (links)
var xS0,yS0;                                               // Süden (links)
var xZ0, yZ0;                                              // Zenit (links)

// Start:

function start () {
  canvas = document.getElementById("cv");                  // Zeichenfläche
  width = canvas.width; height = canvas.height;            // Abmessungen (Pixel)
  ctx = canvas.getContext("2d");                           // Grafikkontext
  xM0 = 150; yM0 = height/2;                               // Erdmittelpunkt (links)   
  phi = 48*DEG;                                            // Geographische Breite (Bogenmaß)
  calculation();                                           // Berechnungen
  drag = false;                                            // Zugmodus zunächst deaktiviert
  paint();                                                 // Zeichnen
  
  canvas.onmousedown = reactionMouseDown;                  // Reaktion auf Drücken der Maustaste
  canvas.ontouchstart = reactionTouchStart;                // Reaktion auf Berührung  
  canvas.onmouseup = reactionMouseUp;                      // Reaktion auf Loslassen der Maustaste
  canvas.ontouchend = reactionTouchEnd;                    // Reaktion auf Ende der Berührung
  canvas.onmousemove = reactionMouseMove;                  // Reaktion auf Bewegen der Maus      
  canvas.ontouchmove = reactionTouchMove;                  // Reaktion auf Bewegen des Fingers     
    
  } // Ende Start
  
// Reaktion auf Drücken der Maustaste:
  
function reactionMouseDown (e) {        
  reactionDown(e.clientX,e.clientY);                       // Hilfsroutine aufrufen (Auswahl)                    
  }
  
// Reaktion auf Berührung:
  
function reactionTouchStart (e) {      
  var obj = e.changedTouches[0];                           // Liste der Berührpunkte
  reactionDown(obj.clientX,obj.clientY);                   // Hilfsroutine aufrufen (Auswahl)
  if (drag) e.preventDefault();                            // Falls Zugmodus aktiviert, Standardverhalten verhindern
  }
  
// Reaktion auf Loslassen der Maustaste:
  
function reactionMouseUp (e) {                                             
  drag = false;                                            // Zugmodus deaktivieren                             
  }
  
// Reaktion auf Ende der Berührung:
  
function reactionTouchEnd (e) {             
  drag = false;                                            // Zugmodus deaktivieren
  }
  
// Reaktion auf Bewegen der Maus:
  
function reactionMouseMove (e) {            
  if (!drag) return;                                       // Abbrechen, falls Zugmodus nicht aktiviert
  reactionMove(e.clientX,e.clientY);                       // Position ermitteln, rechnen und neu zeichnen
  }
  
// Reaktion auf Bewegung des Fingers:
  
function reactionTouchMove (e) {            
  if (!drag) return;                                       // Abbrechen, falls Zugmodus nicht aktiviert
  var obj = e.changedTouches[0];                           // Liste der neuen Fingerpositionen     
  reactionMove(obj.clientX,obj.clientY);                   // Position ermitteln, rechnen und neu zeichnen
  e.preventDefault();                                      // Standardverhalten verhindern                          
  }  
  
// Hilfsroutine: Reaktion auf Mausklick oder Berühren mit dem Finger (Auswahl):
// u, v ... Bildschirmkoordinaten bezüglich Viewport
// Seiteneffekt drag 

function reactionDown (u, v) {
  var re = canvas.getBoundingClientRect();                 // Lage der Zeichenfläche bezüglich Viewport
  u -= re.left; v -= re.top;                               // Koordinaten bezüglich Zeichenfläche (Pixel)
  if (u >= xM0 && u <= xM0+2*R0) drag = true;              // Falls sinnvolle Position, Zugmodus aktivieren
  }
  
// Reaktion auf Bewegung von Maus oder Finger (Änderung):
// u, v ... Bildschirmkoordinaten bezüglich Viewport
// Seiteneffekt phi, xB0, yB0, xN0, yN0, xS0, yS0, xZ0, yZ0, xP1, yP1

function reactionMove (u, v) {
  if (!drag) return;                                       // Falls kein Zugmodus, abbrechen
  var re = canvas.getBoundingClientRect();                 // Lage der Zeichenfläche bezüglich Viewport
  u -= re.left; v -= re.top;                               // Koordinaten bezüglich Zeichenfläche (Pixel)
  phi = Math.atan2(yM0-v,u-xM0);                           // Mittelpunktswinkel (Bogenmaß)
  if (phi > Math.PI/2) phi = Math.PI/2;                    // Maximaler zulässiger Wert
  if (phi < -Math.PI/2) phi = -Math.PI/2;                  // Minimaler zulässiger Wert
  calculation();                                           // Berechnungen
  paint();                                                 // Neu zeichnen  
  }
  
//-------------------------------------------------------------------------------------------------
  
// Berechnungen:
// Seiteneffekt xB0, yB0, xN0, yN0, xS0, yS0, xZ0, yZ0, xP1, yP1

function calculation () {  
  var cos = Math.cos(phi), sin = Math.sin(phi);
  xB0 = xM0+R0*cos; yB0 = yM0-R0*sin;                      // Beobachtungsort (linke Skizze)               
  xN0 = xB0-R1*sin; yN0 = yB0-R1*cos;                      // Norden (linke Skizze)
  xS0 = xB0+R1*sin; yS0 = yB0+R1*cos;                      // Süden (linke Skizze)
  xZ0 = xB0+R1*cos; yZ0 = yB0-R1*sin;                      // Zenit (linke Skizze)
  if (phi < 0) {cos = -cos; sin = -sin;}                   // Vorzeichenumkehr für Südhalbkugel
  xP1 = xB1-R1*cos; yP1 = yB1-R1*sin;                      // Himmelspol (rechte Skizze)  
  }
  
//-------------------------------------------------------------------------------------------------

// Neuer Grafikpfad mit Standardwerten:

function newPath(w) {
  ctx.beginPath();                                         // Neuer Pfad
  ctx.strokeStyle = "#000000";                             // Linienfarbe schwarz
  ctx.lineWidth = 1;                                       // Liniendicke
  }
     
// Linie zeichnen:
// x1, y1 ... Anfangspunkt
// x2, y2 ... Endpunkt
  
function line (x1, y1, x2, y2) {
  newPath();                                               // Neuer Grafikpfad (Standardwerte)
  ctx.moveTo(x1,y1);                                       // Anfangspunkt
  ctx.lineTo(x2,y2);                                       // Weiter zum Endpunkt
  ctx.stroke();                                            // Linie zeichnen
  }
    
// Pfeil zeichnen:
// x1, y1 ... Anfangspunkt
// x2, y2 ... Endpunkt
// w ........ Liniendicke (optional)
// Zu beachten: Die Farbe wird durch ctx.strokeStyle bestimmt.

function arrow (x1, y1, x2, y2, w) {
  if (!w) w = 1;                                           // Falls Liniendicke nicht definiert, Defaultwert                          
  var dx = x2-x1, dy = y2-y1;                              // Vektorkoordinaten
  var length = Math.sqrt(dx*dx+dy*dy);                     // Länge
  if (length == 0) return;                                 // Abbruch, falls Länge 0
  dx /= length; dy /= length;                              // Einheitsvektor
  var s = 2.5*w+7.5;                                       // Länge der Pfeilspitze 
  var xSp = x2-s*dx, ySp = y2-s*dy;                        // Hilfspunkt für Pfeilspitze         
  var h = 0.5*w+3.5;                                       // Halbe Breite der Pfeilspitze
  var xSp1 = xSp-h*dy, ySp1 = ySp+h*dx;                    // Ecke der Pfeilspitze
  var xSp2 = xSp+h*dy, ySp2 = ySp-h*dx;                    // Ecke der Pfeilspitze
  xSp = x2-0.6*s*dx; ySp = y2-0.6*s*dy;                    // Einspringende Ecke der Pfeilspitze
  ctx.beginPath();                                         // Neuer Pfad
  ctx.lineWidth = w;                                       // Liniendicke
  ctx.moveTo(x1,y1);                                       // Anfangspunkt
  if (length < 5) ctx.lineTo(x2,y2);                       // Falls kurzer Pfeil, weiter zum Endpunkt, ...
  else ctx.lineTo(xSp,ySp);                                // ... sonst weiter zur einspringenden Ecke
  ctx.stroke();                                            // Linie zeichnen
  if (length < 5) return;                                  // Falls kurzer Pfeil, keine Spitze
  ctx.beginPath();                                         // Neuer Pfad für Pfeilspitze
  ctx.fillStyle = ctx.strokeStyle;                         // Füllfarbe wie Linienfarbe
  ctx.moveTo(xSp,ySp);                                     // Anfangspunkt (einspringende Ecke)
  ctx.lineTo(xSp1,ySp1);                                   // Weiter zum Punkt auf einer Seite
  ctx.lineTo(x2,y2);                                       // Weiter zur Spitze
  ctx.lineTo(xSp2,ySp2);                                   // Weiter zum Punkt auf der anderen Seite
  ctx.closePath();                                         // Zurück zum Anfangspunkt
  ctx.fill();                                              // Pfeilspitze zeichnen 
  }
  
// Kreis oder Kreisbogen zeichnen:
// x, y ... Koordinaten des Mittelpunkts
// r ...... Radius
// a ...... Winkel im Bogenmaß (optional, Defaultwert 2*Math.PI)
  
function circle (x, y, r, a) {
  newPath();                                               // Neuer Grafikpfad (Standardwerte)
  ctx.arc(x,y,r,0,(a?a:2*Math.PI),true);                   // Kreis oder Kreisbogen vorbereiten
  ctx.stroke();                                            // Kreis oder Kreisbogen zeichnen
  }
  
// Winkelmarkierung im Gegenuhrzeigersinn:
// x, y ... Scheitel
// a0 ..... Startwinkel (Bogenmaß)
// a ...... Winkelbetrag (Bogenmaß) 

function angle (x, y, a0, a) {
  newPath();                                               // Neuer Grafikpfad (Standardwerte)
  ctx.fillStyle = colorAngle;                              // Füllfarbe
  ctx.moveTo(x,y);                                         // Scheitel als Anfangspunkt
  var r = 20;                                              // Radius (Pixel)
  ctx.lineTo(x+r*Math.cos(a0),y-r*Math.sin(a0));           // Linie auf dem ersten Schenkel vorbereiten
  ctx.arc(x,y,r,2*Math.PI-a0,2*Math.PI-a0-a,true);         // Kreisbogen vorbereiten
  ctx.closePath();                                         // Zurück zum Scheitel
  ctx.fill(); ctx.stroke();                                // Kreissektor ausfüllen, Rand zeichnen
  }
  
// Linke Skizze, bezogen auf Erdkugel:

function drawLeft () {
  var w0 = (phi>0 ? 0 : phi);                              // Startwinkel für geographische Breite (Bogenmaß)                    
  var dw = Math.abs(phi);                                  // Betrag der geographischen Breite (Bogenmaß)
  angle(xM0,yM0,w0,dw);                                    // Markierung für geographische Breite
  w0 = (phi>0 ? 90*DEG : 270*DEG+phi);                     // Neuer Startwinkel (Bogenmaß)
  angle(xB0,yB0,w0,dw);                                    // Markierung für Höhenwinkel des sichtbaren Himmelspols
  circle(xM0,yM0,R0);                                      // Erdkugel
  line(xM0,yM0-R0-20,xM0,yM0+R0+20);                       // Erdachse
  line(xM0-R0,yM0,xM0+R0,yM0);                             // Äquator  	
  line(xM0,yM0,xB0,yB0);                                   // Verbindungslinie Erdmittelpunkt-Beobachtungsort
  newPath();                                               // Neuer Grafikpfad (Standardwerte)
  ctx.strokeStyle = colorNorth;                            // Farbe für Nordrichtung
  arrow(xB0,yB0,xN0,yN0,1.5);                              // Pfeil für Nordrichtung
  ctx.strokeStyle = colorSouth;                            // Farbe für Südrichtung
  arrow(xB0,yB0,xS0,yS0,1.5);                              // Pfeil für Südrichtung
  ctx.strokeStyle = colorZenith;                           // Farbe für Zenitrichtung
  arrow(xB0,yB0,xZ0,yZ0,1.5);                              // Pfeil für Zenitrichtung
  ctx.strokeStyle = colorCelestialPole;                    // Farbe für Himmelspol
  if (phi >= 0)                                            // Falls Beobachter auf Nordhalbkugel oder Äquator  ...                          
    arrow(xB0,yB0,xB0,yB0-R1,1.5);                         // Pfeil zum Himmelsnordpol
  if (phi <= 0)                                            // Falls Beobachter auf Südhalbkugel oder Äquator  ...                          
    arrow(xB0,yB0,xB0,yB0+R1,1.5);                         // Pfeil zum Himmelssüdpol
  }
  
// Rechte Skizze, bezogen auf Horizontebene:

function drawRight () {
  var w0 = (phi>0 ? Math.PI-phi : 0);                      // Startwinkel für Höhenwinkel (Bogenmaß)                    
  var dw = Math.abs(phi);                                  // Betrag der geographischen Breite (Bogenmaß)
  angle(xB1,yB1,w0,dw);                                    // Markierung für Höhenwinkel des sichtbaren Himmelspols
  circle(xB1,yB1,R1,Math.PI);                              // Halbkreis für Himmelskugel
  ctx.strokeStyle = colorNorth;                            // Farbe für Nordrichtung
  arrow(xB1,yB1,xB1-R1,yB1,1.5);                           // Pfeil für Nordrichtung
  ctx.strokeStyle = colorSouth;                            // Farbe für Südrichtung
  arrow(xB1,yB1,xB1+R1,yB1,1.5);                           // Pfeil für Südrichtung
  ctx.strokeStyle = colorZenith;                           // Farbe für Zenitrichtung
  arrow(xB1,yB1,xB1,yB1-R1,1.5);                           // Pfeil für Zenitrichtung
  ctx.strokeStyle = colorCelestialPole;                    // Farbe für Himmelspol
  arrow(xB1,yB1,xP1,yP1,1.5);                              // Pfeil zum sichtbaren Himmelspol
  if (phi == 0)                                            // Falls Beobachter auf dem Äquator ... 
    arrow(xB1,yB1,2*xB1-xP1,yP1,1.5);                      // Zusätzlich entgegengesetzter Pfeil
  }
  
// Ausgabe von Text:
// s ....... Zeichenkette
// (x,y) ... Position (Pixel)
// a ....... Textausrichtung (0 für linksbündig, 1 für zentriert, 2 für rechtsbündig)

function write (s, x, y, a) {
  if (a == 0) ctx.textAlign = "left";                      // Entweder linksbündig ...
  else if (a == 1) ctx.textAlign = "center";               // ... oder zentriert ...
  else ctx.textAlign = "right";                            // ... oder rechtsbündig
  ctx.fillText(s,x,y+4);                                   // Text ausgeben
  }
  
// Hilfsroutine: Sicherstellen, dass die x-Koordinate in einem gegebenen Bereich liegt
// x ..... Ursprüngliche x-Koordinate
// min ... Kleinster erlaubter Wert
// max ... Größter erlaubter Wert
// Rückgabewert: Eventuell korrigierte x-Koordinate 

function correctedX (x, min, max) {
  if (x < min) return min;                                 // Zu kleinen Wert verhindern
  if (x > max) return max;                                 // Zu großen Wert verhindern
  return x;                                                // Unkorrigierter Wert
  }
  
// Beschriftung für beide Skizzen:

function writeText () {
  ctx.fillStyle = "#000000";                               // Schriftfarbe
  write(text01,xM0-R0-3,yM0,2);                            // Äquator (linke Skizze)
  write(text02,xM0-3,yM0-R0+10,2);                         // Nordpol (linke Skizze)
  write(text03,xM0-3,yM0+R0-10,2);                         // Südpol (linke Skizze)
  write(text04,xM0,yM0+R0+30,1);                           // Erdachse (linke Skizze)
  write(text05,xB1,yB1+15,1);                              // Horizontebene (rechte Skizze)
  var n = (phi >= 0);                                      // Flag für Nordhalbkugel (einschließlich Äquator)
  var s = (phi <= 0);                                      // Flag für Südhalbkugel (einschließlich Äquator)
  var x = (n ? (xB0+xS0)/2 : (xB0+xN0)/2)+20;              // x-Koordinate
  var y = (n ? (yB0+yS0)/2-15 : (yB0+yN0)/2+15);           // y-Koordinate
  write(text05,x,y,1);                                     // Horizontebene (linke Skizze) 
  x = (n ? xB1+0.85*R1 : xB1-0.85*R1);                     // Neue x-Koordinate
  y = yB1-0.85*R1;                                         // Neue y-Koordinate
  write(text06,x,y,1);                                     // Himmelskugel (rechte Skizze)
  ctx.fillStyle = colorZenith;                             // Neue Schriftfarbe
  x = Math.max(xZ0,xM0)+20;                                // Neue x-Koordinate
  if (n) y = Math.max(yZ0,yM0-R0-R1+15);                   // Neue y-Koordinate für Nordhalbkugel
  else y = Math.min(yZ0,yM0+R0+R1-15);                     // Neue y-Koordinate für Südhalbkugel
  write(text07,x,y,1);                                     // Zenit (linke Skizze)
  write(text07,xB1,yB1-R1-15,1);                           // Zenit (rechte Skizze)
  ctx.fillStyle = colorCelestialPole;                      // Neue Schriftfarbe 
  var cos = Math.cos(phi), sin = Math.sin(phi);            // Trigonometrische Werte 
  if (n) {                                                 // Falls Beobachter auf Nordhalbkugel oder Äquator ...
    write(text08,xB0,yB0-R1-10,1);                         // Himmelsnordpol (linke Skizze)
    x = correctedX(xB1-R1*cos,xB1-80,xB1-30);              // Neue x-Koordinate
    y = yB1-R1*sin-15;                                     // Neue y-Koordinate
    write(text08,x,y,2);                                   // Himmelsnordpol (rechte Skizze)
    }
  if (s) {                                                 // Falls Beobachter auf Südhalbkugel oder Äquator ...
    write(text09,xB0,yB0+R1+10,1);                         // Himmelssüdpol (linke Skizze)
    var wt = ctx.measureText(text09).width;                // Länge der Zeichenkette (Pixel)
    x = correctedX(xB1+R1*cos,xB1+30,xB1+130-wt);          // Neue x-Koordinate 
    y = yB1+R1*sin-15;                                     // Neue y-Koordinate
    write(text09,x,y,0);                                   // Himmelssüdpol (rechte Skizze)
    }
  if (phi == Math.PI/2 || phi == -Math.PI/2) return;       // Falls Beobachter am Nord- oder Südpol, abbrechen 
  ctx.fillStyle = colorNorth;                              // Neue Schriftfarbe
  write(text10,xB1-R1+20,yB1+15,1);                        // Nordrichtung (rechte Skizze)
  if (n) {                                                 // Falls Beobachter auf Nordhalbkugel oder Äquator ...
    x = Math.max(xN0-25,30);                               // Neue x-Koordinate
    y = Math.max(yN0+15,yM0-R0-R1+15);                     // Neue y-Koordinate
    }
  else {x = xN0; y = yN0-15;}                              // Neue Koordinaten für Südhalbkugel 
  write(text10,x,y,1);                                     // Nordrichtung (linke Skizze)
  ctx.fillStyle = colorSouth;                              // Neue Schriftfarbe
  write(text11,xB1+R1-20,yB1+15,1);                        // Südrichtung (rechte Skizze)
  if (s) {                                                 // Falls Beobachter auf Südhalbkugel oder Äquator ...
    x = Math.max(xS0-25,30);                               // Neue x-Koordinate
    y = Math.max(yS0-15,yM0-R0-R1+15);                     // Neue y-Koordinate
    }
  else {x = xS0; y = yS0+15;}                              // Neue Koordinaten für Nordhalbkugel
  write(text11,x,y,1);                                     // Südrichtung (linke Skizze)
  }
      
// Grafikausgabe:
  
function paint () {
  ctx.fillStyle = colorBackground;                         // Hintergrundfarbe
  ctx.fillRect(0,0,width,height);                          // Hintergrund ausfüllen
  ctx.font = FONT;                                         // Zeichensatz 
  drawLeft();                                              // Linke Skizze, bezogen auf Erdkugel 
  drawRight();                                             // Rechte Skizze, bezogen auf Horizontebene
  writeText();                                             // Beschriftung für beide Skizzen
  ctx.fillStyle = "#000000";                               // Schriftfarbe
  write(author,width-40,height-20,2);                      // Autor
  }
  
document.addEventListener("DOMContentLoaded",start,false); // Nach dem Laden der Seite Startmethode aufrufen


