// Apollonios-Problem PPP (drei Punkte)
// Java-Applet (27.12.2008) umgewandelt
// 23.02.2017 - 03.03.2017

// ****************************************************************************
// * Autor: Walter Fendt (www.walter-fendt.de)                                *
// * Dieses Programm darf - auch in vernderter Form - fr nicht-kommerzielle *
// * Zwecke verwendet und weitergegeben werden, solange dieser Hinweis nicht  *
// * entfernt wird.                                                           *
// **************************************************************************** 

// Sprachabhngige Texte sind einer eigenen Datei (zum Beispiel apolloniosproblemppp_de.js) abgespeichert.

// Farben:

var colorBackground = "#ffff00";                           // Hintergrundfarbe
var color1 = "#000000";                                    // Farbe fr gegebene Kreise
var color2 = "#ff0000";                                    // Farbe fr Lsungskreise

// Sonstige Konstanten:

var FONT = "normal normal bold 12px sans-serif";           // Zeichensatz

// Attribute:

var canvas, ctx;                                           // Zeichenflche, Grafikkontext
var width, height;                                         // Abmessungen der Zeichenflche (Pixel)
var lb;                                                    // Ausgabefeld (Zahl der Lsungen)
var nr;                                                    // Nummer des ausgewhlten Punkts (0 bis 3)
var p1, p2, p3;                                            // Gegebene Punkte (Kreise mit Radius 0)

// Element der Schaltflche (aus HTML-Datei):
// id ..... ID im HTML-Befehl
// text ... Text (optional)

function getElement (id, text) {
  var e = document.getElementById(id);                     // Element
  if (text) e.innerHTML = text;                            // Text festlegen, falls definiert
  return e;                                                // Rckgabewert
  } 

// Start:

function start () {
  nr = 0;                                                  // Zunchst nicht ausgewhlt
  canvas = getElement("cv");                               // Zeichenflche
  width = canvas.width; height = canvas.height;            // Abmessungen (Pixel)
  ctx = canvas.getContext("2d");                           // Grafikkontext
  getElement("text2a",text02[0]);                          // Erklrender Text (Aufgabenstellung)
  getElement("text2b",text02[1]);                          // Erklrender Text (Aufgabenstellung)
  getElement("text2c",text02[2]);                          // Erklrender Text (Aufgabenstellung)
  getElement("text2d",text02[3]);                          // Erklrender Text (Aufgabenstellung)
  lb = getElement("lbn");                                  // Ausgabefeld (Anzahl Lsungskreise)
  getElement("text4",text04);                              // Erklrender Text (Zahl der Lsungen)  
  p1 = {x: 200, y: 100, r: 0};                             // 1. gegebener Punkt (Kreis mit Radius 0)
  p2 = {x: 120, y: 240, r: 0};                             // 2. gegebener Punkt (Kreis mit Radius 0)
  p3 = {x: 260, y: 300, r: 0};                             // 3. gegebener Punkt (Kreis mit Radius 0)
  
  getElement("author",author);                             // Autor
  getElement("translator",translator);                     // bersetzer
  paint();                                                 // Zeichnen
  
  canvas.onmousedown = reactionMouseDown;                  // Reaktion auf Drcken der Maustaste
  canvas.ontouchstart = reactionTouchStart;                // Reaktion auf Berhrung  
  canvas.onmouseup = reactionMouseUp;                      // Reaktion auf Loslassen der Maustaste
  canvas.ontouchend = reactionTouchEnd;                    // Reaktion auf Ende der Berhrung
  canvas.onmousemove = reactionMouseMove;                  // Reaktion auf Bewegen der Maus      
  canvas.ontouchmove = reactionTouchMove;                  // Reaktion auf Bewegen des Fingers        
  
  } // Ende der Methode start
  
// Reaktion auf Drcken der Maustaste:
  
function reactionMouseDown (e) {        
  reactionDown(e.clientX,e.clientY);                       // Hilfsroutine aufrufen (Auswahl)                    
  }
  
// Reaktion auf Berhrung:
  
function reactionTouchStart (e) {      
  var obj = e.changedTouches[0];                           // Liste der Berhrpunkte
  reactionDown(obj.clientX,obj.clientY);                   // Hilfsroutine aufrufen (Auswahl)
  if (nr > 0) e.preventDefault();                          // Falls Zugmodus aktiviert, Standardverhalten verhindern
  }
  
// Reaktion auf Loslassen der Maustaste:
  
function reactionMouseUp (e) {                                             
  nr = 0;                                                  // Keine Ecke ausgewhlt, Zugmodus deaktiviert
  }
  
// Reaktion auf Ende der Berhrung:
  
function reactionTouchEnd (e) {             
  nr =0;                                                   // Keine Ecke ausgewhlt, Zugmodus deaktiviert
  }
  
// Reaktion auf Bewegen der Maus:
  
function reactionMouseMove (e) {            
  if (nr == 0) return;                                     // Abbrechen, falls Zugmodus deaktiviert
  reactionMove(e.clientX,e.clientY);                       // Position ermitteln, rechnen und neu zeichnen
  }
  
// Reaktion auf Bewegung des Fingers:
  
function reactionTouchMove (e) {            
  if (nr == 0) return;                                     // Abbrechen, falls Zugmodus deaktiviert
  var obj = e.changedTouches[0];                           // Liste der neuen Fingerpositionen     
  reactionMove(obj.clientX,obj.clientY);                   // Position ermitteln, rechnen und neu zeichnen
  e.preventDefault();                                      // Standardverhalten verhindern                          
  } 
  
// Abstand von einem gegebenen Punkt:
// (u,v) ... Gegebene Position (Pixel)
// p ....... Gegebener Punkt
  
function distance (u, v, p) {
  var dx = u-p.x, dy = v-p.y;                              // Koordinatendifferenzen
  return Math.sqrt(dx*dx+dy*dy);                           // Rckgabewert
  } 
  
// Hilfsroutine: Reaktion auf Mausklick oder Berhren mit dem Finger (Auswahl):
// u, v ... Bildschirmkoordinaten bezglich Viewport
// Seiteneffekt nr

function reactionDown (u, v) {
  var re = canvas.getBoundingClientRect();                 // Lage der Zeichenflche bezglich Viewport
  u -= re.left; v -= re.top;                               // Koordinaten bezglich Zeichenflche (Pixel)  
  var d = distance(u,v,p1);                                // Abstand vom Punkt 1
  var dMin = d;                                            // Vorlufiges Abstandsminimum
  var n = 1;                                               // Nummer fr Punkt 1
  d = distance(u,v,p2);                                    // Abstand vom Punkt 2
  if (d < dMin) {n = 2; dMin = d;}                         // Eventuell Nummer und Abstandsminimum aktualisieren
  d = distance(u,v,p3);                                    // Abstand vom Punkt 3
  if (d < dMin) {n = 3; dMin = d;}                         // Eventuell Nummer und Abstandsminimum aktualisieren
  nr = (dMin<20 ? n : 0);                                  // Falls geringer Abstand, Nummer bernehmen
  }
  
// Reaktion auf Bewegung von Maus oder Finger (nderung):
// u, v ... Bildschirmkoordinaten bezglich Viewport

function reactionMove (u, v) {
  var re = canvas.getBoundingClientRect();                 // Lage der Zeichenflche bezglich Viewport
  u -= re.left; v -= re.top;                               // Koordinaten bezglich Zeichenflche (Pixel)
  if (nr == 0) return;                                     // Gegebenenfalls abbrechen
  if (nr == 1) {p1.x = u; p1.y = v;}                       // Punkt 1 anpassen
  if (nr == 2) {p2.x = u; p2.y = v;}                       // Punkt 2 anpassen
  if (nr == 3) {p3.x = u; p3.y = v;}                       // Punkt 3 anpassen
  paint();                                                 // Neu zeichnen
  }
  
//-------------------------------------------------------------------------------------------------
   
// Koeffizienten einer linearen Gleichung fr x, y, r aus zwei quadratischen Berhr-Bedingungen:
// k1 ... erster Kreis
// s1 ... +1 fr einschlieende, -1 fr ausschlieende Berhrung
// k2 ... zweiter Kreis
// s2 ... +1 fr einschlieende, -1 fr ausschlieende Berhrung
// Rckgabewert r: Array mit den Koeffizienten der linearen Gleichung:
// r[1] * x + r[2] * y + r[3] *  r = r[0]  
    
function coeffLinEqu (k1, s1, k2, s2) {
  var r0 = k2.x*k2.x-k1.x*k1.x+k2.y*k2.y-k1.y*k1.y+k1.r*k1.r-k2.r*k2.r;   // Inhomogener Teil
  var r1 = 2*(k2.x-k1.x);                                  // Koeffizient von x
  var r2 = 2*(k2.y-k1.y);                                  // Koeffizient von y
  var r3 = 2*(s1*k1.r-s2*k2.r);                            // Koeffizient von r  
  return [r0,r1,r2,r3];                                    // Rckgabewert
  }
  
// Lsung eines linearen Gleichungssystems mit 2 Gleichungen und 3 Unbekannten:
// e[0][1] * x + e[0][2] * y + e[0][3] * r = e[0][0]
// e[1][1] * x + e[1][2] * y + e[1][3] * r = e[1][0]
// Rckgabewert s: Koeffizienten-Array, mit dessen Hilfe sich x und y durch r ausdrcken lassen:
// x = s[0][0] * r + s[0][1] 
// y = s[1][0] * r + s[1][1]

function solution23 (e) {
  var det0 = e[0][1]*e[1][2]-e[1][1]*e[0][2];              // Nenner-Determinante (Cramersche Regel)
  var det1r = e[1][3]*e[0][2]-e[0][3]*e[1][2];             // Zhler-Determinante fr s[0][0]
  var det1 = e[0][0]*e[1][2]-e[1][0]*e[0][2];              // Zhler-Determinante fr s[0][1]
  var det2r = e[1][1]*e[0][3]-e[0][1]*e[1][3];             // Zhler-Determinante fr s[1][0]
  var det2 = e[0][1]*e[1][0]-e[1][1]*e[0][0];              // Zhler-Determinante fr s[1][1]
  return [[det1r/det0,det1/det0],[det2r/det0,det2/det0]];  // Rckgabewert (doppelt indiziertes Array)
  }
  
// Lsungskreis:
// Rckgabewert: Array mit 2 Elementen (Lsungskreis bzw. undefined)

function solution () {
  // Lineares Gleichungssystem zur Elimination von x und y
  // a11*x + a12*y + a13*r = b1
  // a21*x + a22*y + a23*r = b2
  var lin = new Array(2);                                  // Neues Array
  lin[0] = coeffLinEqu(p1,1,p2,1);                         // Koeffizienten der ersten linearen Gleichung
  lin[1] = coeffLinEqu(p2,1,p3,1);                         // Koeffizienten der zweiten linearen Gleichung
  var cd = solution23(lin);                                // Koeffizienten-Array, um x und y durch r auszudrcken
  // Ansatz: x = c1*r+d1; y = c2*r+d2;
  var c1 = cd[0][0], d1 = cd[0][1];                        // Koeffizienten fr x
  var c2 = cd[1][0], d2 = cd[1][1];                        // Koeffizienten fr y
  // Einsetzen in Berhr-Bedingung fr Kreis 1
  var e1 = d1-p1.x;                                        // Konstanter Summand
  var e2 = d2-p1.y;                                        // Konstanter Summand
  // Quadratische Gleichung fr r: (c1*r+e1)^2 + (c2*r+e2)^2 = (r-s1*r1)^2
  // Gelst mit Maxima!
  var denom = 1-c1*c1-c2*c2;                               // Nenner
  var discr = (c1*c1+c2*c2)*p1.r*p1.r + 2*(c1*e1+c2*e2)*p1.r    // Diskriminante (Anfang)
    + (1-c1*c1)*e2*e2 + (1-c2*c2)*e1*e1 + 2*c1*c2*e1*e2;        // Diskriminante (Fortsetzung)
  if (discr < 0) return [undefined, undefined];            // Rckgabewert fr negative Diskriminante
  var root = Math.sqrt(discr);                             // Wurzel
  var h = p1.r+c1*e1+c2*e2;                                // Summand auerhalb der Wurzel
  var rs1 = (h+root)/denom, rs2 = (h-root)/denom;          // Lsungen fr Radius r
  var xs1 = c1*rs1+d1, xs2 = c1*rs2+d1;                    // Lsungen fr Mittelpunktskoordinate x
  var ys1 = c2*rs1+d2, ys2 = c2*rs2+d2;                    // Lsungen fr Mittelpunktskoordinate y
  var array = new Array(2);                                // Array vorbereiten
  array[0] = (rs1>0 ? {x: xs1, y: ys1, r: rs1} : undefined);    // 1. Lsung, falls sinnvoll
  array[1] = (rs2>0 && discr>0 ? {x: xs2, y: ys2, r: rs2} : undefined);    // 2. Lsung, falls sinnvoll
  return array;                                            // Rckgabewert
  }
  
// Zahl der Lsungskreise eines gegebenen Typs:
// a ... Array mit 2 Elementen (Lsungskreis bzw. undefined)
  
function numberCircles (a) {
  var n = 0;                                               // Anzahl zunchst 0
  if (a[0]) n++;                                           // Falls 1. Lsung definiert, Anzahl erhhen
  if (a[1]) n++;                                           // Falls 2. Lsung definiert, Anzahl erhhen
  return n;                                                // Rckgabewert
  }
  
//-------------------------------------------------------------------------------------------------
  
// Neuer Grafikpfad (Standardwerte):
// c ... Linienfarbe (optional, Defaultwert schwarz)

function newPath (c) {
  ctx.beginPath();                                         // Neuer Grafikpfad
  ctx.strokeStyle = (c?c:"#000000");                       // Linienfarbe
  ctx.lineWidth = 1;                                       // Liniendicke 1
  }
  
// Kreis zeichnen (kleiner Radius):
// (xM,yM) ... Mittelpunkt
// r ......... Radius
// c ......... Farbe

function circle1 (xM, yM, r, c) {
  newPath(c);                                              // Neuer Grafikpfad
  ctx.arc(xM,yM,r,0,2*Math.PI,true);                       // Kreis vorbereiten
  ctx.stroke();                                            // Kreis zeichnen 
  }
  
// Hilfsroutine: Linker oder rechter Teil eines Kreises mit groem Radius (x als Funktion von y)
// (xM,yM) ... Mittelpunkt
// r ......... Radius
// sgn ....... Vorzeichenfaktor (-1 fr links, +1 fr rechts)
// c ......... Farbe

function circle2x (xM, yM, r, sgn, c) {
  var r1 = r/Math.sqrt(2), r2 = r*r;                       // Hilfsgren (abhngig vom Radius)
  var y0 = Math.max(Math.floor(yM-r1),0);                  // Minimum y-Koordinate   
  var y1 = Math.min(Math.ceil(yM+r1),height);              // Maximum y-Koordinate
  newPath(c);                                              // Neuer Grafikpfad fr linken Viertelkreis oder Teil davon
  yy = y0;                                                 // Aktuelle y-Koordinate
  var dy = yy-yM;                                          // Koordinatendifferenz senkrecht
  xx = xM+sgn*Math.sqrt(r2-dy*dy);                         // Aktuelle x-Koordinate
  ctx.moveTo(xx,yy);                                       // Anfangspunkt
  while (yy < y1) {                                        // Solange unterer Rand noch nicht erreicht ...
    yy++;                                                  // Aktuelle y-Koordinate
    dy = yy-yM;                                            // Koordinatendifferenz senkrecht
    xx = xM+sgn*Math.sqrt(r2-dy*dy);                       // Aktuelle x-Koordinate
    if (xx >= 0 && xx <= width) ctx.lineTo(xx,yy);         // Entweder Linie vorbereiten ...
    else ctx.moveTo(xx,yy);                                // ... oder neuer Anfangspunkt
    }
  ctx.stroke();                                            // Polygonzug zeichnen
  }
  
// Hilfsroutine: Oberer oder unterer Teil eines Kreises mit groem Radius (y als Funktion von x)
// (xM,yM) ... Mittelpunkt
// r ......... Radius
// sgn ....... Vorzeichenfaktor (-1 fr oben, +1 fr unten)
// c ......... Farbe

function circle2y (xM, yM, r, sgn, c) {
  var r1 = r/Math.sqrt(2), r2 = r*r;                       // Hilfsgren (abhngig vom Radius)
  var x0 = Math.max(Math.floor(xM-r1),0);                  // Minimum x-Koordinate
  var x1 = Math.min(Math.ceil(xM+r1),width);               // Maximum x-Koordinate
  newPath(c);                                              // Neuer Grafikpfad fr unteren Viertelkreis oder Teil davon
  var xx = x0;                                             // Aktuelle x-Koordinate
  var dx = xx-xM;                                          // Koordinatendifferenz waagrecht
  var yy = yM+sgn*Math.sqrt(r2-dx*dx);                     // Aktuelle y-Koordinate
  ctx.moveTo(xx,yy);                                       // Anfangspunkt                                   
  while (xx < x1) {                                        // Solange rechter Rand noch nicht erreicht ...
    xx++;                                                  // Aktuelle x-Koordinate
    dx = xx-xM;                                            // Koordinatendifferenz waagrecht
    yy = yM+sgn*Math.sqrt(r2-dx*dx);                       // Aktuelle y-Koordinate                           
    if (yy >= 0 && yy <= height) ctx.lineTo(xx,yy);        // Entweder Linie vorbereiten ...
    else ctx.moveTo(xx,yy);                                // ... oder neuer Anfangspunkt
    }
  ctx.stroke();                                            // Polygonzug zeichnen
  }
  
// Kreis zeichnen (groer Radius):
// (xM,yM) ... Mittelpunkt
// r ......... Radius
// c ......... Farbe

function circle2 (xM, yM, r, c) {
  circle2x(xM,yM,r,-1,c);                                  // Linker Teil des Kreises
  circle2x(xM,yM,r,1,c);                                   // Rechter Teil des Kreises
  circle2y(xM,yM,r,-1,c);                                  // Oberer Teil des Kreises
  circle2y(xM,yM,r,1,c);                                   // Unterer Teil des Kreises
  }
    
// Kreis zeichnen:
// k ... Kreis
// m ... Flag fr Mittelpunktsmarkierung
// c ... Farbe (Kreislinie, Mittelpunkt) 
  
function drawCircle (k, m, c) {
  if (!k) return;                                          // Falls Kreis nicht definiert, abbrechen
  if (k.r < 1000) circle1(k.x,k.y,k.r,c);                  // Entweder Kreis mit kleinem Radius
  else circle2(k.x,k.y,k.r,c);                             // ... oder Kreis mit groem Radius
  if (m) drawPoint(k,c);                                   // Falls gewnscht, Mittelpunkt einzeichnen
  }
  
// Text mit Index (schwarz):
// t ....... Text ('_' als Trennzeichen zwischen normalem Text und Index)
// (x,y) ... Position
// left .... Flag fr Linksverschiebung

function textIndex (t, x, y, left) {
  var i = t.indexOf("_");                                  // Index Unterstrich oder -1
  var t1 = (i>=0 ? t.substring(0,i) : t);                  // Text ohne Index
  var t2 = (i>=0 ? t.substring(i+1) : "");                 // Index
  var l1 = ctx.measureText(t1).width;                      // Lnge des normalen Textes (Pixel)
  if (left) x -= l1+ctx.measureText(t2).width;             // Falls gewnscht, nach links verschieben
  ctx.fillStyle = "#000000";                               // Schriftfarbe
  ctx.fillText(t1,x,y);                                    // Normaler Text
  ctx.fillText(t2,x+l1,y+4);                               // Index
  }
  
// Punkt beschriften:
// p ... Punkt
// n ... Bezeichnung

function namePoint (p, n) {
  var x0 = width/2, y0 = height/2;                         // Bezugspunkt (Mittelpunkt der Zeichenflche)
  var w = Math.atan2(y0-p.y,p.x-x0);                       // Winkel
  var r = 6;                                               // Abstand der Beschriftung vom Punkt
  var x = p.x+r*Math.cos(w), y = p.y-r*Math.sin(w);        // Position Beschriftung
  textIndex(n,x,y,x<p.x);
  }
  
// Punkt zeichnen:
// p ... Punkt
// c ... Farbe
// n ... Bezeichnung (optional)

function drawPoint (p, c, n) {
  newPath();                                               // Neuer Grafikpfad (Standardwerte)
  ctx.arc(p.x,p.y,2,0,2*Math.PI,true);                     // Kreis vorbereiten
  ctx.fillStyle = c; ctx.fill();                           // Ausgefllten Kreis zeichnen
  if (n) namePoint(p,n);                                   // Falls gewnscht, Punkt beschriften
  }
  
// Lsungskreise zeichnen:
// Rckgabewert: Zahl der Lsungen des gegebenen Typs
// Die Zahl der Lsungen fr die einzelnen Typen wird in der Schaltflche aktualisiert.
  
function drawSolutions () {
  var a = solution();                                      // Array der Lsungskreise
  if (a[0]) drawCircle(a[0],false,color2);                 // Gegebenenfalls 1. Lsungskreis zeichnen
  if (a[1]) drawCircle(a[1],false,color2);                 // Gegebenenfalls 2. Lsungskreis zeichnen
  var n = numberCircles(a);                                // Zahl der Lsungen
  lb.innerHTML = (n==1 ? ""+n : "&infin;");                // Lsungszahl in der Schaltflche aktualisieren
  return n;                                                // Rckgabewert
  }
  
// Grafikausgabe:
  
function paint () {
  ctx.fillStyle = colorBackground;                         // Hintergrundfarbe
  ctx.fillRect(0,0,width,height);                          // Hintergrund ausfllen
  ctx.font = FONT;                                         // Zeichensatz
  drawPoint(p1,color1,namePoint1);                         // Erster gegebener Punkt
  drawPoint(p2,color1,namePoint2);                         // Zweiter gegebener Punkt
  drawPoint(p3,color1,namePoint3);                         // Dritter gegebener Punkt
  drawSolutions();                                         // Lsungskreis
  }
  
document.addEventListener("DOMContentLoaded",start,false); // Nach dem Laden der Seite Start-Methode aufrufen

