// Klasse QPolVal (Quotient zweier multivariater Polynome mit ganzzahligen Koeffizienten)
// Die Klasse verwendet zwei Attribute, numerator fr das Zhlerpolynom, denominator fr das Nennerpolynom (beide vom Typ Polynomial).
// Gemeinsame Faktoren von Zhler- und Nennerpolynom werden herausgekrzt.
// 02.07.2020 - 15.08.2020

class QPolVal {

// Konstruktor:
// n ... Zhlerpolynom (Typ Polynomial)
// d ... Nennerpolynom (Typ Polynomial)

  constructor (n, d) {
    this.numerator = n;                                    // Zhler bernehmen
    this.denominator = d;                                  // Nenner bernehmen
    this.normal();                                         // Normalisierung (Krzen)
    }
    
// Vereinfachung (Krzen, Vermeidung eines einfachen negativen Nenners); das gegebene QPolVal-Objekt wird hierbei verndert! 

  normal () {
    var n = this.numerator, d = this.denominator;          // Abkrzungen fr Zhler- und Nennerpolynom
    if (d.isZero()) return;                                // Falls Nennerpolynom gleich 0, abbrechen
    if (n.isZero()) {                                      // Falls Zhlerpolynom gleich 0 ...
      this.denominator = newPolynomialInt(1n);             // Nennerpolynom gleich 1
      return;                                              // Abbrechen
      }
    var b1 = n.gcdCoeff(), b2 = d.gcdCoeff();              // ggTs der Koeffizienten in Zhler und Nenner (Typ BigInt)
    var b = gcd(b1,b2);                                    // ggT der beiden Zwischenergebnisse (Typ BigInt)
    n.divBigInt(b); d.divBigInt(b);                        // Zhler- und Nennerpolynom durch b dividieren
    for (var i=0; i<variables.length; i++) {               // Fr alle Variablen-Indizes ... 
      var e1 = n.minExpo(i), e2 = d.minExpo(i);            // Minimale Exponenten bezglich Variable in Zhler und Nenner
      var e = (e2<e1?e2:e1);                               // Minimaler Exponent bezglich Variable
      n.divVarPow(i,e); d.divVarPow(i,e);                  // Zhler- und Nennerpolynom durch Variablenpotenz dividieren
      }
    if (d.list.length == 1) {                              // Falls nur ein Monom im Nenner ...
      b = d.list[0].coeff;                                 // Koeffizient dieses Monoms
      if (b < 0n) {                                        // Falls Koeffizient negativ ...
        this.numerator = n.negate();                       // Zhlerpolynom umkehren
        this.denominator = d.negate();                     // Nennerpolynom umkehren
        }
      }
    var f = n.gcd(d);                                      // ggT von Zhler- und Nennerpolynom (Typ Polynomial)
    this.numerator = n.div(f);                             // Zhlerpolynom durch f dividieren
    this.denominator = d.div(f);                           // Nennerpolynom durch f dividieren
    this.numerator.factorize(0);                           // Faktorisierung des Zhlerpolynoms
    this.denominator.factorize(0);                         // Faktorisierung des Nennerpolynoms
    }
    
// Kopie:

  clone () {
    var n = this.numerator.clone();                        // Kopie des Zhlers
    var d = this.denominator.clone();                      // Kopie des Nenners
    return new QPolVal(n,d);                               // Rckgabewert
    }
    
// Vorzeichenumkehr (neues QPolVal-Objekt):

  negate () {
    var n = this.numerator.negate();                       // Umgekehrtes Zhlerpolynom
    var d = this.denominator.clone();                      // Kopie des Nennerpolynoms
    return new QPolVal(n,d);                               // Rckgabewert
    }
    
// Summe des gegebenen QPolVal-Objekts und eines weiteren QPolVal-Objekts:
// qp ... Zweites QPolVal-Objekt (zweiter Summand)

  add (qp) {
    if (qp == undefined) return undefined;                 // Falls 2. Summand undefiniert, Summe undefiniert
    var n1 = this.numerator, n2 = qp.numerator;            // Gegebene Zhler
    var d1 = this.denominator, d2 = qp.denominator;        // Gegebene Nenner
    var n = n1.mul(d2).add(n2.mul(d1)), d = d1.mul(d2);    // Zhler und Nenner der Summe
    return new QPolVal(n,d);                               // Rckgabewert (normalisiert)  
    }
    
// Differenz des gegebenen QPolVal-Objekts und eines weiteren QPolVal-Objekts:
// qp ... Zweites QPolVal-Objekt (Subtrahend)

  sub (qp) {
    if (qp == undefined) return undefined;                 // Falls Subtrahend undefiniert, Differenz undefiniert
    var n1 = this.numerator, n2 = qp.numerator;            // Gegebene Zhler
    var d1 = this.denominator, d2 = qp.denominator;        // Gegebene Nenner
    var n = n1.mul(d2).sub(n2.mul(d1)), d = d1.mul(d2);    // Zhler und Nenner der Differenz  
    return new QPolVal(n,d);                               // Rckgabewert (normalisiert)  
    }
    
// Produkt des gegebenen QPolVal-Objekts und eines weiteren QPolVal-Objekts:
// qp ... Zweites QPolVal-Objekt (zweiter Faktor)

  mul (qp) {
    if (qp == undefined) return undefined;                 // Falls 2. Faktor undefiniert, Produkt undefiniert
    var n1 = this.numerator, n2 = qp.numerator;            // Gegebene Zhler
    var d1 = this.denominator, d2 = qp.denominator;        // Gegebene Nenner
    var n = n1.mul(n2), d = d1.mul(d2);                    // Zhler und Nenner des Produkts
    return new QPolVal(n,d);                               // Rckgabewert (normalisiert)
    }
    
// Quotient des gegebenen QPolVal-Objekts und eines weiteren QPolVal-Objekts:
// qp ... Zweites QPolVal-Objekt (Divisor)

  div (qp) {
    if (qp == undefined) return undefined;                 // Falls Divisor undefiniert, Quotient undefiniert
    if (qp.isZero()) return undefined;                     // Falls Divisor gleich 0, Quotient undefiniert
    var n1 = this.numerator, n2 = qp.numerator;            // Gegebene Zhler
    var d1 = this.denominator, d2 = qp.denominator;        // Gegebene Nenner
    var n = n1.mul(d2), d = d1.mul(n2);                    // Zhler und Nenner des Quotienten
    return new QPolVal(n,d);                               // Rckgabewert (normalisiert)
    }
    
// Kehrwert:

  reciprocal () {
    if (this.isZero()) return undefined;                   // Kehrwert von 0 undefiniert
    var n = this.denominator.clone();                      // Nenner des gegebenen QPolVal-Objekts (Kopie)
    var d = this.numerator.clone();                        // Zhler des gegebenen QPolVal-Objekts (Kopie)
    return new QPolVal(n,d);                               // Rckgabewert (normalisiert)
    }
    
// Potenz des gegebenen QPolVal-Objekts und einer ganzen Zahl:
// e ... Exponent (ganzzahlig, Typ BigInt, nicht Number!)

  pow (e) {
    if (e == undefined) return undefined;                  // Falls Exponent undefiniert, Potenz undefiniert
    var pos = true;                                        // Flag fr positiven Exponenten
    var p = qpRatVal(1n);                                  // Variable fr Produkt (Typ QPolVal), Startwert 1
    if (e  < 0n) {                                         // Falls Exponent negativ ...
      pos = false;                                         // Flag fr positiven Exponenten lschen 
      e = 0n-e;                                            // Exponent durch Betrag ersetzen
      }
    while (e > 0n) {                                       // Solange e positiv ...
      p = p.mul(this);                                     // Bisheriges Produkt mit Basis multiplizieren
      e = e-1n;                                            // e um 1 erniedrigen
      }
    return (pos ? p : p.reciprocal());                     // Rckgabewert
    }
    
// berprfung, ob QPolVal-Objekt gleich 0:

  isZero () {
    var n = this.numerator, d = this.denominator;          // Abkrzungen fr Zhler und Nenner
    var z1 = (n != undefined && n.isZero());               // Zhler definiert und gleich 0?
    var z2 = (d != undefined && !d.isZero());              // Nenner definiert und ungleich 0?
    return (z1 && z2);                                     // Rckgabewert
    }
    
// berprfung, ob das gegebene QPolVal-Objekt mit einem anderen bereinstimmt:

  equals (qp) {
    return this.sub(qp).isZero();                          // Rckgabewert
    }
    
// Umwandlung in ein BigInt-Objekt (fr Exponent einer Potenz):
// Bei Misserfolg Rckgabewert undefined

  toBigInt () {
    var n = this.numerator, d = this.denominator;          // Abkrzungen fr Zhler und Nenner
    if (!n.isInt() || !d.isInt()) return undefined;        // Rckgabewert, falls Zhler oder Nenner nicht ganzzahlig
    if (n.isZero()) return 0n;                             // Rckgabewert, falls gegebenes QPolVal-Objekt gleich 0
    var q1 = n.list[0].coeff, q2 = d.list[0].coeff;        // Zhler und Nenner als BigInt-Objekte
    return (q1%q2==0n ? q1/q2 : undefined);                // Rckgabewert
    }
    
// Grafikausgabe:
// (x,y) ... Position (Pixel)

  write (x, y) {
    var n = this.numerator, d = this.denominator;          // Zhler- und Nennerpolynom (Typ Polynomial)
    if (d.isOne()) n.write(x,y);                           // Falls Nennerpolynom gleich 1, nur Zhlerpolynom ausgeben
    else {                                                 // Falls Nennerpolynom ungleich 1 ...
      if (d.isNegative()) {
        n.changeSign(); d.changeSign();
        }
      var w1 = n.width(), w2 = d.width();                  // Breite von Zhler- und Nennerpolynom (Pixel)
      var w = Math.max(w1,w2)+widthPix(" ");               // Breite des Bruchstrichs (Pixel)
      n.write(x+(w-w1)/2,y-10);                            // Zhlerpolynom
      d.write(x+(w-w2)/2,y+14);                            // Nennerpolynom
      line(x,y-4,x+w,y-4);                                 // Bruchstrich
      }
    }
    
// Grafikausgabe (Faktorisierung):
// (x,y) ... Position (Pixel)

  writeFactors (x, y) {
    var n = this.numerator, d = this.denominator;          // Zhler- und Nennerpolynom (Typ Polynomial)
    if (d.isOne()) n.writeFactors(x,y);                    // Falls Nennerpolynom gleich 1, nur Zhlerpolynom ausgeben
    else {                                                 // Falls Nennerpolynom ungleich 1 ...
      if (d.signFactor0() < 0) {                           // Falls negativer Vorfaktor im Nenner ...
        n.factors[0].changeSign();                         // Vorfaktor im Zhler umkehren
        d.factors[0].changeSign();                         // Vorfaktor im Nenner umkehren
        } 
      var w1 = n.widthFactors(), w2 = d.widthFactors();    // Breite von Zhler- und Nennerpolynom (Pixel)
      var w = Math.max(w1,w2)+widthPix(" ");               // Breite des Bruchstrichs (Pixel)
      n.writeFactors(x+(w-w1)/2,y-10);                     // Zhlerpolynom, faktorisiert
      d.writeFactors(x+(w-w2)/2,y+14);                     // Nennerpolynom, faktorisiert
      line(x,y-4,x+w,y-4);                                 // Bruchstrich
      }
    }
    
  } // Ende der Klasse QPolVal
  
//-------------------------------------------------------------------------------------------------

// Konstruktor-Ersatz fr rationale Zahl:
// n ... Zhler (Typ BigInt)
// d ... Nenner (Typ BigInt, optional, Defaultwert 1)

function qpRatVal (n, d) {
  if (d == undefined) d = 1n;                              // Falls Nenner undefiniert, Defaultwert 1
  if (d == 0n) return undefined;                           // Falls Nenner gleich 0, Rckgabewert undefiniert
  var f = gcd(n,d);                                        // Grter gemeinsamer Teiler von Zhler und Nenner
  n = n/f; d = d/f;                                        // Bruch krzen (Typ BigInt)
  var p1 = newPolynomialInt(n);                            // Zhlerpolynom (Typ Polynomial)
  var p2 = newPolynomialInt(d);                            // Nennerpolynom (Typ Polynomial)
  return new QPolVal(p1,p2);                               // Rckgabewert
  }
  

  
  