// Klasse GF (Element des Galois-Felds GF(p^n))
// 26.07.2022 - 01.08.2022
// Es wird ein Array coeff der Lnge n verwendet, das die Koeffizienten (vom Typ ZP) enthlt.
// Wichtig: q, p, n, coeffPower mssen definiert sein.

class GF {

  // Konstruktor:
  
  constructor (c) {
    this.coeff = c;                                        // Koeffizienten-Array bernehmen                                      
    }
    
  // bereinstimmung mit einem anderen Element von GF(p^n):
    
  equals (e2) {
    var c1 = this.coeff, c2 = e2.coeff;                     // Koeffizienten-Arrays
    if (c1 == undefined || c2 == undefined) return false;   // Rckgabewert, falls Koeffizienten-Array nicht definiert
  	if (c1.length != n || c2.length != n) return false;     // Rckgabewert, falls Array-Gre falsch
  	for (var i=0; i<n; i++)                                 // Fr alle Indizes bzw. Exponenten ...
  	  if (!c1[i].equals(c2[i])) return false;               // Rckgabewert, falls Abweichung
  	return true;                                            // Rckgabewert, falls keine Abweichung
    }
    
  // bereinstimmung mit dem Nullelement von GF(p^n):
    
  isZero () {
    var c = this.coeff;                                    // Koeffizienten-Array
    if (c == undefined) return false;                      // Rckgabewert, falls Koeffizienten-Array nicht definiert
    if (c.length != n) return false;                       // Rckgabewert, falls Array-Gre falsch
    for (var i=0; i<n; i++)                                // Fr alle Indizes bzw. Exponenten ...
  	  if (!c[i].isZero()) return false;                    // Rckgabewert, falls Koeffizient ungleich 0
  	return true;                                           // Rckgabewert, falls alle Koeffizienten gleich 0
  	}
  	
  // bereinstimmung mit dem Einselement von GF(p^n):
  	
  isOne () {
    var c = this.coeff;                                    // Koeffizienten-Array
    if (c == undefined) return false;                      // Rckgabewert, falls Koeffizienten-Array nicht definiert
    if (c.length != n) return false;                       // Rckgabewert, falls Array-Gre falsch
  	if (!c[0].isOne()) return false;                       // Rckgabewert, falls Abweichung von 1 bei Index 0
  	else if (n == 1) return true;                          // Rckgabewert, falls Einselement von GF(p)
  	for (var i=1; i<n; i++)                                // Fr alle Indizes bzw. Exponenten ab 1 ...
  	  if (!c[i].isZero()) return false;                    // Rckgabewert, falls Koeffizient ungleich 0
  	return true;                                           // Rckgabewert, falls keine Abweichung
    }
    
  // Addition eines weiteren Elements von GF(p^n):
    
  add (e2) {
    var c1 = this.coeff, c2 = e2.coeff;                    // Koeffizienten-Arrays
    if (c1 == undefined || c2 == undefined)                // Falls Koeffizienten-Array nicht definiert ...
      return undefined;                                    // Rckgabewert undefiniert
  	if (c1.length != n || c2.length != n)                  // Falls Array-Gre falsch ...
  	  return undefined;                                    // Rckgabewert undefiniert
  	var c = new Array(n);                                  // Neues Array fr Koeffizienten
  	for (var i=0; i<n; i++)                                // Fr alle Indizes bzw. Exponenten ...
  	  c[i] = c1[i].add(c2[i]);                             // Aktueller Koeffizient
  	return new GF(c);                                      // Rckgabewert
    }
    
  // Subtraktion eines weiteren Elements von GF(p^n):
    
  sub (e2) {
    var c1 = this.coeff, c2 = e2.coeff;                    // Koeffizienten-Arrays
    if (c1 == undefined || c2 == undefined)                // Falls Koeffizienten-Array nicht definiert ...
      return undefined;                                    // Rckgabewert undefiniert
  	if (c1.length != n || c2.length != n)                  // Falls Array-Gre falsch ...
  	  return undefined;                                    // Rckgabewert undefiniert
  	var c = new Array(n);                                  // Neues Array fr Koeffizienten
  	for (var i=0; i<n; i++)                                // Fr alle Indizes bzw. Exponenten ...
  	  c[i] = c1[i].sub(c2[i]);                             // Aktueller Koeffizient
  	return new GF(c);                                      // Rckgabewert
    }
    
  // Inverses Element bezglich Addition:
  
  neg () {
    var c0 = this.coeff;                                   // Koeffizienten-Array
    if (c0 == undefined) return undefined;                 // Rckgabewert, falls Koeffizienten-Array nicht definiert
    if (c0.length != n) return undefined;                  // Rckgabewert, falls Array-Gre falsch
    var c = new Array(n);                                  // Neues Array fr Koeffizienten
    for (var i=0; i<n; i++)                                // Fr alle Indizes bzw. Exponenten ...
      c[i] = c0[i].neg();                                  // Aktueller Koeffizient
    return new GF(c);                                      // Rckgabewert
    } 
    
  // Multiplikation eines weiteren Elements von GF(p^n):
    
  mul (e2) {
    if (e2 == undefined) return undefined;                 // Sonderfall: Zweiter Faktor nicht definiert
    var c1 = this.coeff, c2 = e2.coeff;                    // Koeffizienten-Arrays
    if (c1 == undefined || c2 == undefined)                // Falls Koeffizienten-Array nicht definiert ...
      return undefined;                                    // Rckgabewert undefiniert
  	if (c1.length != n || c2.length != n)                  // Falls Array-Gre falsch ...
  	  return undefined;                                    // Rckgabewert undefiniert
  	var c = new Array(n);                                  // Neues Array fr Koeffizienten
  	for (var k=0; k<n; k++) c[k] = new ZP(0);              // Koeffizienten zunchst gleich 0
  	for (var i=0; i<n; i++) {                              // Fr alle Indizes bzw. Exponenten (1. Faktor) ...
  	  for (var j=0; j<n; j++) {                            // Fr alle Indizes bzw. Exponenten (2. Faktor) ...
  	    var h = c1[i].mul(c2[j]);                          // Hilfsgre (Produkt von Koeffizienten)
  	    for (var k=0; k<n; k++)                            // Fr alle Indizes (Ergebnis) ...
  	      c[k] = c[k].add(h.mul(coeffPower[i+j][k]));      // Koeffizient aktualisieren	
  	    }
  	  } // Ende for (i)
  	return new GF(c);                                      // Rckgabewert
    }
    
  // Inverses Element bezglich Multiplikation:
  // Systematisches Probieren, bei Misserfolg Rckgabewert undefined
  
  inverse () {
    var c = this.coeff;                                    // Koeffizienten-Array
    if (c == undefined) return undefined;                  // Rckgabewert, falls Koeffizienten-Array nicht definiert
    if (c.length != n) return undefined;                   // Rckgabewert, falls Array-Gre falsch
  	if (this.isZero()) return undefined;                   // Rckgabewert, falls Argument gleich Nullelement
  	for (var i=1; i<q; i++) {                              // Fr alle Indizes von 1 bis q-1 ...
  	  var e = gfIndex(i);                                  // Zugehriges Krperelement
  	  if (this.mul(e).isOne()) return e;                   // Rckgabewert, falls Produkt gleich 1
  	  }
  	return undefined;                                      // Rckgabewert, falls kein Inverses gefunden
    }
    
  // Division durch ein weiteres Element von GF(p^n):
  // Zur Verringerung der Rechenzeit wird das Array inv verwendet, in dem die inversen Elemente gespeichert sind.
  
  div (e2) {
    var c1 = this.coeff, c2 = e2.coeff;                    // Koeffizienten-Arrays
    if (c1 == undefined || c2 == undefined)                // Falls Koeffizienten-Array nicht definiert ...
      return undefined;                                    // Rckgabewert undefiniert
  	if (c1.length != n || c2.length != n)                  // Falls Array-Gre falsch ...
  	  return undefined;                                    // Rckgabewert undefiniert
  	if (e2.isZero()) return undefined;                     // Rckgabewert, falls Division durch Nullelement
  	if (n > 1) return this.mul(inv[e2.index()]);           // Rckgabewert (Normalfall)
    }
    
  // Monom als Zeichenkette:
  // i ... Exponent bzw. Index (0 bis n-1)
  	
  stringMonomial (i) {
  	var c = this.coeff[i];                                 // Koeffizient
  	var s = String(c);                                     // Koeffizient als Zeichenkette
  	if (i == 0) return s;                                  // Rckgabewert, falls Exponent gleich 0
  	if (c.isZero()) return "0";                            // Rckgabewert, falls Koeffizient gleich 0
  	if (c.isOne()) s = "";                                 // Falls Koeffizient gleich 1, weglassen
  	s += root;                                             // Symbol fr Wurzel des Minimalpolynoms
  	if (i > 1) s += "^"+i;                                 // Falls sinnvoll, Potenz
  	return s;                                              // Rckgabewert
    }
    
  // Umwandlung in eine Zeichenkette:
    
  toString () {
    if (this.coeff == undefined) return "?";               // Rckgabewert, falls Koeffizienten-Array nicht definiert
  	if (this.isZero()) return "0";                         // Rckgabewert, falls Nullelement
  	var s = "";                                            // Startwert Zeichenkette
  	var first = true;                                      // Flag fr 1. Summand, Startwert                                     
  	for (var i=0; i<n; i++) {                              // Fr alle Indizes bzw. Exponenten ...
  	  var m = this.stringMonomial(i);                      // Aktueles Monom als Zeichenkette
  	  if (m == "0") continue;                              // Falls Nullmonom, weiter zum nchsten Index
  	  if (first) first = false;                            // Entweder Falg fr 1. Summand lschen ...
  	  else s += " + ";                                     // ... oder Pluszeichen sowie Leerzeichen hinzufgen
  	  s += m;                                              // Zeichenkette fr aktuelles Monom hinzufgen
  	  }
  	return s;                                              // Rckgabewert
    }  
    
  // Index (gem Horner-Schema):
  
  index () {
    var s = 0;                                             // Startwert
    for (var i=n-1; i>=0; i--) {                           // Fr alle Indizes bzw. Exponenten (absteigend) ...
      s *= p;                                              // Mit Charakteristik p multiplizieren 
      s += this.coeff[i].z;                                // Index des aktuellen Summanden addieren
      }
    return s;                                              // Rckgabewert
    }
    
  // Grafikausgabe eines Monoms:
  // i ....... Index bzw. Exponent
  // (x,y) ... Position (Pixel)
  // Rckgabewert: Neue x-Koordinate (Pixel)
    
  writeMonomial (i, x, y) {  	
  	var c = this.coeff[i];                                 // Koeffizient
  	var s = String(c);                                     // Koeffizient als Zeichenkette
  	if (i == 0 || c.isZero()) return writeString(s,x,y);   // Exponent oder Koeffizient gleich 0  	
  	if (c.isOne()) s = "";                                 // Falls Koeffizient gleich 1, weglassen
  	else x = writeString(s,x,y)+5;                         // Ausgabe eines Koeffizienten ungleich 1, neue x-Koordinate
  	x = writeString(root,x,y);                             // Symbol fr Wurzel des Minimalpolynoms, neue x-Koordinate
  	if (i > 1) x = writeString(String(i),x,y-5);           // Ausgabe des Exponenten, falls sinnvoll, neue x-Koordinate
  	return x;                                              // Rckgabewert
    }
    
  // Breite eines Monoms (kompatibel mit writeMonomial):
  // i ... Index bzw. Exponent
    
  widthMonomial (i) {
  	var w = 0;                                              // Startwert Breite
  	var c = this.coeff[i];                                  // Koeffizient
  	var dw = widthString(String(c));                        // Breite Koeffizient (Pixel)
  	if (i == 0 || c.isZero()) return dw;                    // Rckgabewert, falls Exponent oder Koeffizient gleich 0
  	if (!c.isOne()) w = dw+5;                               // Breite von Koeffizient und Abstand (Pixel)
  	w += widthString(root);                                 // Breite des Wurzelsymbols addieren (Pixel)
  	if (i > 1) w += widthString(String(i));                 // Breite des Exponenten addieren (Pixel)
  	return w;                                               // Rckgabewert
    }
    
  // Grafikausgabe des Krperelements (als Summe von Monomen bezglich Alpha):
  // (x,y) ... Position (Pixel)
  // Rckgabewert: Neue x-Koordinate (Pixel)
  
  write (x, y) {
    var c = this.coeff;                                    // Koeffizienten-Array
  	if (c == undefined) return writeString("?",x,y);       // Sonderfall: Koeffizienten-Array nicht definiert
  	if (this.isZero()) return writeString("0",x,y);        // Sonderfall: Nullelement
  	var first = true;                                      // Flag fr 1. Summand, Startwert 
  	for (var i=0; i<c.length; i++) {                       // Fr alle Indizes bzw. Exponenten ...
  	  if (c[i].isZero()) continue;                         // Falls Nullmonom, weiter zum nchsten Index
  	  if (first) first = false;                            // Entweder Flag fr 1. Summand lschen ...
  	  else x = writeString(" + ",x,y);                     // ... oder Pluszeichen mit Leerzeichen, neue x-Koordinate                   
  	  x = this.writeMonomial(i,x,y);                       // Monom ausgeben, neue x-Koordinate
  	  }
  	return x;                                              // Rckgabewert
    }
    
  // Gesamtbreite (Pixel, kompatibel zur vorhergehenden Methode write):
    
  width () {
    var c = this.coeff;                                    // Koeffizienten-Array
  	if (c == undefined) return widthString("?");           // Sonderfall: Koeffizienten-Array nicht definiert
  	if (this.isZero()) return widthString("0");            // Sonderfall: Nullelement
  	var first = true;                                      // Flag fr 1. Summand, Startwert
  	var w = 0;                                             // Startwert Breite
  	for (var i=0; i<c.length; i++) {                       // Fr alle Indizes bzw. Exponenten ...
  	  if (c[i].isZero()) continue;                         // Falls Nullmonom, weiter zum nchsten Index
  	  if (first) first = false;                            // Entweder Flag fr 1. Summand lschen ...
  	  else w += widthString(" + ");                        // ... oder Breite erhhen (Pluszeichen mit Leerzeichen)
  	  w += this.widthMonomial(i);                          // Breite des aktuellen Monoms addieren 
  	  }
  	return w;                                              // Rckgabewert
    }
    
  // Zentrierte Grafikausgabe:
  // (x,y) ... Position (Pixel)
  
  center (x, y) {
    this.write(x-this.width()/2,y);                        // Methode fr linksbndige Ausgabe aufrufen
    }

  } // Ende der Klasse GF
  
