// Sehnenviereck
// Java-Applet (26.10.1997), umgewandelt in HTML5/Javascript
// 16.01.2016 - 27.11.2017

// Farben:

var colorBackground = "#ffff00";                           // Hintergrundfarbe
var colorFill = "#ffffff";                                 // Farbe fr das Innere des Vierecks
var colors = ["#ff0000", "#008000", "#e0a000", "#0000ff"]; // Farben der Winkelmarkierungen
var colorPoint = "#ff00ff";                                // Farbe der Punkte

// Sonstige Konstanten:

var FONT = "normal normal bold 12px sans-serif";           // Zeichensatz
var PI2 = 2*Math.PI;                                       // Abkrzung fr 2 pi
var R = 200;                                               // Umkreisradius (Pixel)
var DEG = Math.PI/180;                                     // 1 Grad (Bogenma)
var nr;                                                    // Index der ausgewhlten Ecke (0 bis 3 oder -1)

// Attribute:

var canvas, ctx;                                           // Zeichenflche, Grafikkontext
var width, height;                                         // Abmessungen der Zeichenflche (Pixel)
var xM, yM;                                                // Umkreismittelpunkt (Pixel)
var x, y;                                                  // Arrays der Koordinaten der Ecken (relativ zum Mittelpunkt)
var my;                                                    // Array der Positionswinkel (Bogenma)

// Start:
	
function start () {
  canvas = document.getElementById("cv");                  // Zeichenflche
  width = canvas.width; height = canvas.height;            // Abmessungen (Pixel)
  ctx = canvas.getContext("2d");                           // Grafikkontext
  xM = width/2; yM = height/2;                             // Umkreismittelpunkt (Pixel)
  my = new Array(30*DEG,70*DEG,220*DEG,310*DEG);           // Array fr Positionswinkel der Ecken (Bogenma)
  x = new Array(4); y = new Array(4);                      // Arrays fr Koordinaten der Ecken
  calculation();                                           // Koordinaten der Ecken berechnen
  nr = -1;                                                 // Zunchst keine Ecke ausgewhlt (Zugmodus abgeschaltet)
  paint();                                                 // Zeichnen
  
  canvas.onmousedown = reactionMouseDown;                  // Reaktion auf Drcken der Maustaste
  canvas.ontouchstart = reactionTouchStart;                // Reaktion auf Berhrung  
  canvas.onmouseup = reactionMouseUp;                      // Reaktion auf Loslassen der Maustaste
  canvas.ontouchend = reactionTouchEnd;                    // Reaktion auf Ende der Berhrung
  canvas.onmousemove = reactionMouseMove;                  // Reaktion auf Bewegen der Maus      
  canvas.ontouchmove = reactionTouchMove;                  // Reaktion auf Bewegen des Fingers   
  }
  
// Reaktion auf Drcken der Maustaste:
  
function reactionMouseDown (e) {        
  reactionDown(e.clientX,e.clientY);                       // Hilfsroutine aufrufen (Auswahl)                    
  }
  
// Reaktion auf Berhrung:
  
function reactionTouchStart (e) {      
  var obj = e.changedTouches[0];                           // Liste der Berhrpunkte
  reactionDown(obj.clientX,obj.clientY);                   // Hilfsroutine aufrufen (Auswahl)
  if (nr >= 0) e.preventDefault();                         // Falls Zugmodus aktiviert, Standardverhalten verhindern
  }
  
// Reaktion auf Loslassen der Maustaste:
  
function reactionMouseUp (e) {                                             
  nr = -1;                                                 // Zugmodus deaktivieren                             
  }
  
// Reaktion auf Ende der Berhrung:
  
function reactionTouchEnd (e) {             
  nr = -1;                                                 // Zugmodus deaktivieren
  }
  
// Reaktion auf Bewegen der Maus:
  
function reactionMouseMove (e) { 
  if (nr < 0) return;                                      // Abbrechen, falls Zugmodus nicht aktiviert
  reactionMove(e.clientX,e.clientY);                       // Position ermitteln, rechnen und neu zeichnen   
  }
  
// Reaktion auf Bewegung des Fingers:
  
function reactionTouchMove (e) {   
  if (nr < 0) return;                                      // Abbrechen, falls Zugmodus nicht aktiviert
  var obj = e.changedTouches[0];                           // Liste der neuen Fingerpositionen     
  reactionMove(obj.clientX,obj.clientY);                   // Position ermitteln, rechnen und neu zeichnen
  e.preventDefault();                                      // Standardverhalten verhindern    
  }
  
// Hilfsroutine: Reaktion auf Mausklick oder Berhren mit dem Finger (Auswahl einer Ecke):
// u, v ... Bildschirmkoordinaten bezglich Viewport
// Seiteneffekt nr

function reactionDown (u, v) {
  var re = canvas.getBoundingClientRect();                 // Lage der Zeichenflche bezglich Viewport
  u -= re.left; v -= re.top;                               // Koordinaten bezglich Zeichenflche (Pixel) 
  var x0 = u-xM, y0 = yM-v;                                // Koordinaten bezglich Mittelpunkt
  nr = -1;                                                 // Zunchst keine Ecke ausgewhlt
  var min2 = 1000000;                                      // Sehr groer Startwert fr Abstandsquadrat
  for (var i=0; i<4; i++) {                                // Fr alle Ecken ...
    var dx = x0-x[i], dy = y0-y[i];                        // Verbindungsvektor
    var d2 = dx*dx+dy*dy;                                  // Abstandsquadrat
    if (d2 < min2) {min2 = d2; nr = i;}                    // Falls Abstand kleiner als bisher, Werte aktualisieren
    }
  if (min2 > 400) nr = -1;                                 // Falls Abstand zu gro, keine Ecke auswhlen
  }
  
// Reaktion auf Bewegung von Maus oder Finger (nderung der aktuellen Ecke):
// u, v ... Bildschirmkoordinaten bezglich Viewport
// Seiteneffekt x, y, my 

function reactionMove (u, v) {
  if (nr < 0) return;                                      // Falls keine Ecke ausgewhlt, abbrechen
  var re = canvas.getBoundingClientRect();                 // Lage der Zeichenflche bezglich Viewport
  u -= re.left; v -= re.top;                               // Koordinaten bezglich Zeichenflche (Pixel)
  var iPrev = (nr+3)%4;                                    // Index der vorhergehenden Ecke
  var min = my[iPrev]; if (min > my[nr]) min -= PI2;       // Minimum fr neuen Positionswinkel
  var iNext = (nr+1)%4;                                    // Index der nchsten Ecke
  var max = my[iNext]; if (max < my[nr]) max += PI2;       // Maximum fr neuen Positionswinkel
  var w = corrAngle(Math.atan2(yM-v,u-xM));                // Neuer Positionswinkel (Intervall 0 bis 2 pi)
  if (w > my[nr]+Math.PI) w -= PI2;                        // Korrektur bei bergang vom 1. zum 4. Quadranten                      
  if (w < my[nr]-Math.PI) w += PI2;                        // Korrektur bei bergang vom 4. zum 1. Quadranten
  if (w < min) w = min;                                    // Zu kleinen Positionswinkel verhindern
  if (w > max) w = max;                                    // Zu groen Positionswinkel verhindern
  my[nr] = w;                                              // Positionswinkel speichern
  calculation();                                           // Koordinaten der Ecken neu berechnen
  paint();                                                 // Neu zeichnen
  }
  
//-------------------------------------------------------------------------------------------------

// Winkel korrigieren (Wert zwischen 0 und 2 pi erzwingen):

function corrAngle (w) {
  return w-Math.floor(w/PI2)*PI2;
  }
  
// Berechnung der Koordinaten der Ecken:
// Seiteneffekt x, y
  
function calculation () {
  for (var i=0; i<4; i++) {                                // Fr alle Ecken-Indizes ...
    x[i] = R*Math.cos(my[i]);                              // Waagrechte Koordinate (bezglich Mittelpunkt)
    y[i] = R*Math.sin(my[i]);                              // Senkrechte Koordinate (bezglich Mittelpunkt)
    }
  }
  
// Index der Seite mit berstumpfem Mittelpunktswinkel:
// Falls keine solche Seite existiert (Umkreismittelpunkt innerhalb des Vierecks), Rckgabewert -1
  
function specialIndex () {
  for (var i=0; i<4; i++) {                                // Fr alle Ecken-Indizes ...
    var iNext = (i+1)%4;                                   // Index der nchsten Ecke
    var w = corrAngle(my[iNext]-my[i]);                    // Mittelpunktswinkel
    if (w > Math.PI) return i;                             // Falls Winkel berstumpf, Index als Rckgabewert
    }
  return -1;                                               // Rckgabewert -1, da kein berstumpfer Mittelpunktswinkel
  }
  
//-------------------------------------------------------------------------------------------------

// Neuer Grafikpfad mit Standardwerten:

function newPath () {
  ctx.beginPath();                                         // Neuer Grafikpfad
  ctx.strokeStyle = "#000000";                             // Linienfarbe schwarz
  ctx.lineWidth = 1;                                       // Liniendicke 1
  }
  
// Linie:
// (x1,y1) ... Anfangspunkt (Koordinaten bezglich Mittelpunkt)
// (x2,y2) ... Endpunkt (Koordinaten bezglich Mittelpunkt)
// c ......... Farbe (optional)
// w ......... Liniendicke (optional, Defaultwert 1)

function line (x1, y1, x2, y2, c, w) {
  ctx.beginPath();                                         // Neuer Grafikpfad
  if (c) ctx.strokeStyle = c;                              // Linienfarbe, falls angegeben
  ctx.lineWidth = (w ? w : 1);                             // Liniendicke, falls angegeben
  ctx.moveTo(xM+x1,yM-y1); ctx.lineTo(xM+x2,yM-y2);        // Linie vorbereiten
  ctx.stroke();                                            // Linie zeichnen
  }
  
// Sehnenviereck:

function quadrilateral () {
  newPath();                                               // Neuer Grafikpfad (Standardwerte)
  ctx.fillStyle = colorFill;                               // Fllfarbe
  ctx.moveTo(xM+x[0],yM-y[0]);                             // Anfangspunkt (Ecke mit Index 0)
  for (var i=1; i<4; i++)                                  // Fr alle weiteren Indizes ... 
    ctx.lineTo(xM+x[i],yM-y[i]);                           // Weiter zur nchsten Ecke
  ctx.closePath();                                         // Zurck zum Anfangspunkt
  ctx.fill(); ctx.stroke();                                // Ausgeflltes Viereck mit Rand
  }
  
// Punkt:
// i ... Index (0 bis 3)

function point (i) {
  ctx.beginPath();                                         // Neuer Grafikpfad
  ctx.fillStyle = colorPoint;                              // Fllfarbe
  ctx.arc(xM+x[i],yM-y[i],2,0,PI2,true);                   // Kreis vorbereiten
  ctx.fill();                                              // Ausgefllter Kreis
  }
  
// Einzelne Winkelmarkierung:
// (x,y) ... Bildschirmkoordinaten des Scheitels
// a0 ...... Startwinkel (Bogenma)
// a ....... Winkelgre (Bogenma, positiv fr Gegenuhrzeigersinn)
// c ....... Fllfarbe
// r ....... Radius (optional, Defaultwert 20)
  
function angle (x, y, a0, a, c, r) {
  if (a < 0) {a = Math.abs(a); a0 -= a;}                   // Bei negativem Winkel Parameterwerte verndern
  newPath();                                               // Neuer Grafikpfad (Standardwerte) 
  ctx.fillStyle = c;                                       // Fllfarbe                 
  ctx.arc(x,y,r?r:20,PI2-a0,PI2-a0-a,true);                // Kreisbogen vorbereiten
  ctx.lineTo(x,y);                                         // Weiter zum Scheitel
  ctx.closePath();                                         // Zurck zum Anfangspunkt des Kreisbogens
  ctx.fill();                                              // Kreissektor ausfllen
  ctx.stroke();                                            // Rand zeichnen
  }
  
// Paar von Basiswinkeln markieren:
// i ... Index des aktuellen Scheitels
// r ... Radius (Pixel)
  
function baseAngles (i, r) {
  var c = colors[i];                                       // Fllfarbe
  var iNext = (i+1)%4;                                     // Index der nchsten Ecke
  var x0 = xM+x[i], y0 = yM-y[i];                          // Bildschirmkoordinaten des aktuellen Scheitels
  var xNext = xM+x[iNext], yNext = yM-y[iNext];            // Bildschirmkoordinaten des nchsten Scheitels
  var ca = corrAngle(my[iNext]-my[i]);                     // Mittelpunktswinkel (Bogenma)
  var bw = (Math.PI-ca)/2;                                 // Basiswinkel
  var def = (Math.abs(x0-xNext)+Math.abs(y0-yNext) > 0.1); // berprfung, ob Winkel definiert
  var a0 = Math.atan2(y0-yNext,xNext-x0);                  // Startwinkel fr Markierung bei aktueller Ecke 
  if (def) angle(x0,y0,a0,bw,c,r);                         // Winkelmarkierung bei aktueller Ecke
  a0 = Math.atan2(yNext-yM,xM-xNext);                      // Startwinkel fr Markierung bei nchster Ecke
  if (def) angle(xNext,yNext,a0,bw,c,r);                   // Winkelmarkierung bei nchster Ecke
  }
  
// Zeichnen:
  
function paint () {
  ctx.fillStyle = colorBackground;                         // Hintergrundfarbe
  ctx.fillRect(0,0,width,height);                          // Hintergrund ausfllen
  newPath();                                               // Neuer Grafikpfad (Standardwerte)
  ctx.arc(xM,yM,R,0,PI2,true);                             // Umkreis vorbereiten
  ctx.stroke();                                            // Umkreis zeichnen
  quadrilateral();                                         // Viereck (ausgefllt)
  var i0 = specialIndex();                                 // Index der Seite mit berstumpfem Mittelpunktswinkel oder -1
  if (i0 >= 0) baseAngles(i0,40);                          // Gegebenenfalls Paar von Basiswinkeln mit grerem Radius markieren
  for (var i=0; i<4; i++) {                                // Fr alle Indizes ...
    if (i != i0) baseAngles(i,20);                         // Falls sinnvoll, Paar von Basiswinkeln markieren
    }
  for (i=0; i<4; i++) line(0,0,x[i],y[i]);                 // Verbindungslinien zwischen Mittelpunkt und Ecken
  for (i=0; i<4; i++) point(i);                            // Ecken
  ctx.font = FONT;                                         // Zeichensatz
  ctx.textAlign = "right";                                 // Textausrichtung
  ctx.fillStyle = "#000000";                               // Schriftfarbe
  ctx.fillText("W. Fendt 1997",width-20,height-20);        // Autor
  }

document.addEventListener("DOMContentLoaded",start,false); // Nach dem Laden der Seite Start-Methode aufrufen
