// Javascript fr HTML5-Apps (portugiesisch Portugal)
// 18.01.2016 - 12.02.2019

// Konstanten:

var language = "pt";                                                 // Abkrzung fr Sprache
var textMath = "Matem&aacute;tica";                                  // Bezeichnung fr Mathematik
var textCollection = "Apps de Matem&aacute;tica";                    // Bezeichnung fr Programmsammlung
var textModification = "Ultima actualiza&ccedil;&atilde;o";          // Bezeichnung fr letzte nderung
var textTranslation = "Tradu&ccedil;&atilde;o";                      // Bezeichnung fr bersetzung
var linkTranslation = '<a href="http://www.casadasciencias.org" target="_blank">'
                      + '<img src="casa1.gif" alt="Casa das Ci&ecirc;ncias" border=0></a>'
                      + ' Casa das Ci&ecirc;ncias, 2009<br>';

// Array der Monatsnamen:

var month = ["Janeiro", "Fevereiro", "Mar&ccedil;o", "Abril", "Maio", "Junho", 
             "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"];

// Logo Mathematik-Apps:

function logo (filename) {
  var t = document.createElement("div");                             // Neues div-Element (bergeordnet)
  t.setAttribute("id","Index");                                      // Attribut id setzen (Layout-Festlegung durch CSS-Datei)
  var t1 = document.createElement("div");                            // Neues div-Element (oben)
  t1.setAttribute("id","Index1");                                    // Attribut id setzen (Layout-Festlegung durch CSS-Datei)
  t.appendChild(t1);                                                 // div-Element hinzufgen
  var t2 = document.createElement("div");                            // Neues div-Element (unten)
  t2.setAttribute("id","Index2");                                    // Attribut id setzen (Layout-Festlegung durch CSS-Datei)
  t.appendChild(t2);                                                 // div-Element hinzufgen
  var a1 = document.createElement("a");                              // Neuer Link (fr Logo)
  a1.setAttribute("href","index.html");                              // Adresse fr Inhaltsverzeichnis
  var i = document.createElement("img");                             // Neues Bild (Logo Mathematik)
  i.setAttribute("src","../m/javamath.gif");                         // Pfadangabe (Bilddatei)
  i.setAttribute("alt",textMath);                                    // Alternativer Text
  a1.appendChild(i);                                                 // Bild zum Link hinzufgen
  t1.appendChild(a1);                                                // Link zum oberen div-Element hinzufgen
  var a2 = document.createElement("a");                              // Neuer Link (fr Text)
  a2.setAttribute("href","index.html");                              // Adresse fr Inhaltsverzeichnis
  a2.innerHTML = textCollection;                                     // Text fr Link
  t2.appendChild(a2);                                                // Link zum unteren div-Element hinzufgen
  var body = document.getElementsByTagName("body")[0];               // Body-Element
  body.appendChild(t);                                               // bergeordnetes div-Element hinzufgen
  }
 
// Datum nach dem Muster "1 de Janeiro de 2000"
// d ... Tag (1 bis 31)
// m ... Monat (1 bis 12)
// y ... Jahr
  
function date (d, m, y) {
  return ""+d+" de "+month[m-1]+" de "+y;
  }
  
// Daten am Ende der Seite (URL, Copyright, bersetzung, letzte nderung)

function data (filename, d1, m1, y1, d2, m2, y2, trl) {
  var body = document.getElementsByTagName("body")[0];               // Body-Element
  var p = document.createElement("p");                               // Neuer Absatz
  p.setAttribute("class","Ende");                                    // Klasse (Layout-Festlegung durch CSS-Datei)
  var s = "URL: https://www.walter-fendt.de/html5/m"+language+"/";   // Anfang der URL
  s += filename+"_"+language+".htm<br>";                             // URL vervollstndigen, Zeilenumbruch
  s += "Walter Fendt, "+date(d1,m1,y1)+"<br>";                       // Autor, Datum, Zeilenumbruch
  if (trl) s += textTranslation+": ";                                // bersetzung
  if (trl == "cdc") s += linkTranslation;                            // Link Casa das Cincias
  if (trl == "criar") s += "criar.no.sapo.pt<br>";
  if (trl == "sdm") s += "www.saladematematica.com.br<br>";
  if (trl == "ramada") s += "departamentos.esramada.pt<br>";
  s += textModification+": "+date(d2,m2,y2)+"<br>&nbsp;<br>";        // Datum der letzten nderung, Zeilenumbruch
  var a = '<a rel="license" href="http://creativecommons.org/licenses/by-nc-sa/4.0/">';
  s += a+'<img alt="Creative Commons License" style="border-width:0" ';
  s += 'src="https://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png" /></a><br />';
  s += 'This work is licensed under a ';
  s += a+'Creative Commons Attribution-NonCommercial-ShareAlike ';
  s += '4.0 International License</a>.';
  p.innerHTML = s;                                                   // Inhalt des Absatzes
  body.appendChild(p);                                               // Absatz hinzufgen
  }
  
// Leere Zeile 
  
function emptyLine () {
  var e = document.createElement("div");                             // Neues Div-Element
  e.setAttribute("class","Abstand");                                 // Klasse (Layout-Festlegung durch CSS-Datei)
  e.innerHTML = "\u0020";                                            // Leerzeichen
  return e;                                                          // Rckgabewert
  }
  
// Seitenende insgesamt
// filename ..... Dateiname (ohne Erweiterungen)
// d1, m1, y1 ... Datum der Erstverffentlichung
// d2, m2, y2 ... Datum der letzten nderung

function endPage (filename, d1, m1, y1, d2, m2, y2, trl) {
  var body = document.getElementsByTagName("body")[0];               // Body-Element
  body.appendChild(emptyLine());                                     // Leere Zeile hinzufgen
  var hr = document.createElement("hr");                             // Trennstrich
  hr.setAttribute("class","Trennlinie");                             // Klasse (Layout-Festlegung durch CSS-Datei)
  body.appendChild(hr);                                              // Trennstrich hinzufgen
  body.appendChild(emptyLine());                                     // Leere Zeile hinzufgen
  logo(filename);                                                    // Logo
  data(filename,d1,m1,y1,d2,m2,y2,trl);                              // Daten am Ende (URL, Copyright, bersetzung, letzte nderung)
  }
  
  
  
